/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.spi.Connection;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jdi.internal.JDIMessages;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.connect.SocketAttachingConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketLaunchingConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketListeningConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketRawLaunchingConnectorImpl;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugOptions;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;

public class VirtualMachineManagerImpl
implements VirtualMachineManager {
    public static int MAJOR_INTERFACE_VERSION = 1;
    public static int MINOR_INTERFACE_VERSION = 5;
    private PrintWriter fVerbosePrintWriter = null;
    List<VirtualMachine> fConnectedVMs = new ArrayList<VirtualMachine>();
    private String fVerboseFile;

    public VirtualMachineManagerImpl() {
        this.getPreferences();
        if (VirtualMachineManagerImpl.isVerboseTracingEnabled()) {
            FileOutputStream out = null;
            if (this.fVerboseFile != null && this.fVerboseFile.length() > 0) {
                try {
                    out = new FileOutputStream(this.fVerboseFile);
                }
                catch (IOException e) {
                    JDIDebugPlugin.logError(JDIMessages.VirtualMachineManagerImpl_Could_not_open_verbose_file___1 + this.fVerboseFile + JDIMessages.VirtualMachineManagerImpl_____2, e);
                }
            }
            this.fVerbosePrintWriter = out == null ? new PrintWriter(new StringWriter()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flush() {
                    super.flush();
                    StringWriter writer = new StringWriter();
                    Object object = this.lock;
                    synchronized (object) {
                        JDIDebugOptions.trace("org.eclipse.jdt.debug/debug/jdi/verbose", this.out.toString(), null);
                        this.out = writer;
                        this.lock = writer;
                    }
                }
            } : new PrintWriter(out);
        }
    }

    @Override
    public int majorInterfaceVersion() {
        return MAJOR_INTERFACE_VERSION;
    }

    @Override
    public int minorInterfaceVersion() {
        return MINOR_INTERFACE_VERSION;
    }

    public static boolean isVerboseTracingEnabled() {
        return JDIDebugOptions.DEBUG_JDI_VEBOSE;
    }

    static String getTracingFileName() {
        return JDIDebugOptions.DEBUG_JDI_VEBOSE_FILE;
    }

    private void getPreferences() {
        if (VirtualMachineManagerImpl.isVerboseTracingEnabled()) {
            this.fVerboseFile = VirtualMachineManagerImpl.getTracingFileName();
        }
    }

    public int getGlobalRequestTimeout() {
        try {
            IPreferencesService srvc = Platform.getPreferencesService();
            if (srvc != null) {
                return Platform.getPreferencesService().getInt(JDIDebugModel.getPluginIdentifier(), JDIDebugModel.PREF_REQUEST_TIMEOUT, 3000, null);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return 3000;
    }

    public void addConnectedVM(VirtualMachineImpl vm) {
        this.fConnectedVMs.add(vm);
    }

    public void removeConnectedVM(VirtualMachineImpl vm) {
        this.fConnectedVMs.remove(vm);
    }

    @Override
    public List<VirtualMachine> connectedVirtualMachines() {
        return this.fConnectedVMs;
    }

    @Override
    public List<Connector> allConnectors() {
        ArrayList<Connector> result = new ArrayList<Connector>(this.attachingConnectors());
        result.addAll(this.launchingConnectors());
        result.addAll(this.listeningConnectors());
        return result;
    }

    @Override
    public List<AttachingConnector> attachingConnectors() {
        ArrayList<AttachingConnector> list = new ArrayList<AttachingConnector>(1);
        list.add(new SocketAttachingConnectorImpl(this));
        return list;
    }

    @Override
    public List<LaunchingConnector> launchingConnectors() {
        ArrayList<LaunchingConnector> list = new ArrayList<LaunchingConnector>(2);
        list.add(new SocketLaunchingConnectorImpl(this));
        list.add(new SocketRawLaunchingConnectorImpl(this));
        return list;
    }

    @Override
    public List<ListeningConnector> listeningConnectors() {
        ArrayList<ListeningConnector> list = new ArrayList<ListeningConnector>(1);
        list.add(new SocketListeningConnectorImpl(this));
        return list;
    }

    @Override
    public LaunchingConnector defaultConnector() {
        return new SocketLaunchingConnectorImpl(this);
    }

    public PrintWriter verbosePrintWriter() {
        return this.fVerbosePrintWriter;
    }

    @Override
    public VirtualMachine createVirtualMachine(Connection connection) throws IOException {
        VirtualMachineImpl vmImpl = new VirtualMachineImpl(connection);
        return vmImpl;
    }

    @Override
    public VirtualMachine createVirtualMachine(Connection connection, Process process) throws IOException {
        VirtualMachineImpl vmImpl = new VirtualMachineImpl(connection);
        vmImpl.setLaunchedProcess(process);
        return vmImpl;
    }
}

