/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public final class DiscoverySelectorIdentifier {
    private final String prefix;
    private final String value;

    public static DiscoverySelectorIdentifier create(String prefix, String value) {
        return new DiscoverySelectorIdentifier(prefix, value);
    }

    public static DiscoverySelectorIdentifier parse(String string) {
        return (DiscoverySelectorIdentifier)StringUtils.splitIntoTwo((char)':', (String)string).mapTwo(() -> new PreconditionViolationException("Identifier string must be 'prefix:value', but was " + string), DiscoverySelectorIdentifier::new);
    }

    private DiscoverySelectorIdentifier(String prefix, String value) {
        this.prefix = Preconditions.notBlank((String)prefix, (String)"prefix must not be blank");
        this.value = Preconditions.notBlank((String)value, (String)"value must not be blank");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoverySelectorIdentifier that = (DiscoverySelectorIdentifier)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.value);
    }

    public String toString() {
        return "%s:%s".formatted(this.prefix, this.value);
    }
}

