/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants.diagnostics;

import java.util.List;
import java.util.Map;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.xerces.AbstractReferencedGrammarLSPErrorReporter;
import org.eclipse.lemminx.extensions.xerces.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;

public class LSPErrorReporterForXSD
extends AbstractReferencedGrammarLSPErrorReporter {
    private static final String XSD_DIAGNOSTIC_SOURCE = "xsd";

    public LSPErrorReporterForXSD(DOMDocument xmlDocument, List<Diagnostic> diagnostics, ContentModelManager contentModelManager, boolean hasRelatedInformation, Map<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache) {
        super(XSD_DIAGNOSTIC_SOURCE, xmlDocument, diagnostics, contentModelManager, hasRelatedInformation, referencedGrammarDiagnosticsInfoCache);
    }

    @Override
    protected Range toLSPRange(XMLLocator location, String key, Object[] arguments, String message, DiagnosticSeverity diagnosticSeverity, boolean fatalError, DOMDocument document, String documentOrGrammarURI, boolean errorForDocument) {
        XMLSchemaErrorCode schemaCode;
        XMLSyntaxErrorCode syntaxCode;
        XSDErrorCode xsdCode = XSDErrorCode.get(key);
        if (xsdCode != null) {
            if (errorForDocument || XSDErrorCode.src_import_1_2.equals(xsdCode) || XSDErrorCode.src_import_3_1.equals(xsdCode) || XSDErrorCode.src_import_3_2.equals(xsdCode)) {
                Range range = XSDErrorCode.toLSPRange(location, xsdCode, arguments, document);
                if (range != null) {
                    return range;
                }
            } else {
                this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), null, null, null, xsdCode, null, null, documentOrGrammarURI);
                return NO_RANGE;
            }
        }
        if ((syntaxCode = XMLSyntaxErrorCode.get(key)) != null) {
            if (errorForDocument) {
                Range range = XMLSyntaxErrorCode.toLSPRange(location, syntaxCode, arguments, document);
                if (range != null) {
                    return range;
                }
            } else {
                this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), syntaxCode, null, null, null, null, null, documentOrGrammarURI);
                return NO_RANGE;
            }
        }
        if ((schemaCode = XMLSchemaErrorCode.get(key)) != null) {
            if (errorForDocument) {
                Range range = XMLSchemaErrorCode.toLSPRange(location, schemaCode, arguments, document);
                if (range != null) {
                    return range;
                }
            } else {
                this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), null, schemaCode, null, null, null, null, documentOrGrammarURI);
                return NO_RANGE;
            }
        }
        return null;
    }

    @Override
    protected Range getReferencedGrammarRange(String grammarURI) {
        DOMAttr schemaLocationAttr = XSDUtils.findSchemaLocationAttrByURI(this.getDOMDocument(), grammarURI);
        if (schemaLocationAttr != null) {
            return XMLPositionUtility.selectAttributeValue(schemaLocationAttr);
        }
        return XMLPositionUtility.selectRootStartTag(this.getDOMDocument());
    }
}

