/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.filter.MetadataFilter;
import org.apache.tika.metadata.filter.NoOpFilter;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.AbstractRecursiveParserWrapperHandler;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.utils.ParserUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RecursiveParserWrapperHandler
extends AbstractRecursiveParserWrapperHandler {
    protected final List<Metadata> metadataList = new LinkedList<Metadata>();
    private final MetadataFilter metadataFilter;

    public RecursiveParserWrapperHandler(ContentHandlerFactory contentHandlerFactory) {
        this(contentHandlerFactory, -1, NoOpFilter.NOOP_FILTER);
    }

    public RecursiveParserWrapperHandler(ContentHandlerFactory contentHandlerFactory, int maxEmbeddedResources) {
        this(contentHandlerFactory, maxEmbeddedResources, NoOpFilter.NOOP_FILTER);
    }

    public RecursiveParserWrapperHandler(ContentHandlerFactory contentHandlerFactory, int maxEmbeddedResources, MetadataFilter metadataFilter) {
        super(contentHandlerFactory, maxEmbeddedResources);
        this.metadataFilter = metadataFilter;
    }

    @Override
    public void startEmbeddedDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        super.startEmbeddedDocument(contentHandler, metadata);
    }

    @Override
    public void endEmbeddedDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        super.endEmbeddedDocument(contentHandler, metadata);
        this.addContent(contentHandler, metadata);
        try {
            this.metadataFilter.filter(metadata);
        }
        catch (TikaException e) {
            throw new SAXException(e);
        }
        if (metadata.size() > 0) {
            this.metadataList.add(ParserUtils.cloneMetadata(metadata));
        }
    }

    @Override
    public void endDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        super.endDocument(contentHandler, metadata);
        this.addContent(contentHandler, metadata);
        try {
            this.metadataFilter.filter(metadata);
        }
        catch (TikaException e) {
            throw new SAXException(e);
        }
        if (metadata.size() > 0) {
            this.metadataList.add(0, ParserUtils.cloneMetadata(metadata));
        }
        this.writeFinalEmbeddedPaths();
    }

    private void writeFinalEmbeddedPaths() {
        HashMap<String, String> idToName = new HashMap<String, String>();
        AtomicInteger unknownCount = new AtomicInteger(0);
        for (Metadata metadata : this.metadataList) {
            String id = metadata.get(TikaCoreProperties.EMBEDDED_ID);
            if (id == null) continue;
            String name = RecursiveParserWrapper.getResourceName(metadata, unknownCount);
            idToName.put(id, name);
        }
        for (Metadata metadata : this.metadataList) {
            String idPath = metadata.get(TikaCoreProperties.EMBEDDED_ID_PATH);
            if (idPath == null) continue;
            if (idPath.startsWith("/")) {
                idPath = idPath.substring(1);
            }
            String[] ids = idPath.split("/");
            StringBuilder sb = new StringBuilder();
            for (String id : ids) {
                sb.append("/").append((String)idToName.get(id));
            }
            metadata.set(TikaCoreProperties.FINAL_EMBEDDED_RESOURCE_PATH, sb.toString());
        }
    }

    public List<Metadata> getMetadataList() {
        return this.metadataList;
    }

    void addContent(ContentHandler handler, Metadata metadata) {
        String content;
        if (!handler.getClass().equals(DefaultHandler.class) && (content = handler.toString()) != null && !content.isBlank()) {
            metadata.add(TikaCoreProperties.TIKA_CONTENT, content);
            metadata.add(TikaCoreProperties.TIKA_CONTENT_HANDLER, handler.getClass().getSimpleName());
        }
    }
}

