/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.collect.internal;

import java.lang.reflect.InvocationTargetException;
import org.apache.maven.shared.transfer.dependencies.collect.DependencyCollectorException;

final class Invoker {
    private Invoker() {
    }

    public static <T> T invoke(Object object, String method) throws DependencyCollectorException {
        try {
            Object invoke = object.getClass().getMethod(method, new Class[0]).invoke(object, new Object[0]);
            return (T)invoke;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }

    public static <T> T invoke(Class<?> objectClazz, String staticMethod, Class<?> argClazz, Object arg) throws DependencyCollectorException {
        try {
            Object invoke = objectClazz.getMethod(staticMethod, argClazz).invoke(null, arg);
            return (T)invoke;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }

    public static <T> T invoke(Class<?> objectClazz, String staticMethod, Class<?>[] argClasses, Object[] args) throws DependencyCollectorException {
        if (args.length != argClasses.length) {
            throw new IllegalArgumentException("The number of elements in argClasses and args are not the same.");
        }
        try {
            Object invoke = objectClazz.getMethod(staticMethod, argClasses).invoke(null, args);
            return (T)invoke;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }
}

