/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.core.collection.InteractionByTypeSummary;
import org.eclipse.mylyn.internal.monitor.core.collection.InteractionEventUtil;
import org.eclipse.mylyn.internal.monitor.core.collection.Messages;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class CommandUsageCollector
implements IUsageCollector {
    private final InteractionByTypeSummary commands = new InteractionByTypeSummary();
    private final Set<Integer> userIdSet = new HashSet<Integer>();

    @Override
    public void consumeEvent(InteractionEvent event, int userId) {
        this.userIdSet.add(userId);
        if (event.getKind().equals((Object)InteractionEvent.Kind.COMMAND)) {
            this.commands.setUserCount(userId, InteractionEventUtil.getCleanOriginId(event), this.commands.getUserCount(userId, InteractionEventUtil.getCleanOriginId(event)) + 1);
        }
    }

    @Override
    public List<String> getReport() {
        return Collections.emptyList();
    }

    @Override
    public String getReportTitle() {
        return Messages.CommandUsageCollector_Command_Usage;
    }

    @Override
    public void exportAsCSVFile(String directoryName) {
    }

    public InteractionByTypeSummary getCommands() {
        return this.commands;
    }

    @Override
    public List<String> getPlainTextReport() {
        return Collections.emptyList();
    }
}

