/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PrototypeTab
extends AbstractLaunchConfigurationTab {
    private static final String PROTOTYPE_TAB_ID = "org.eclipse.debug.ui.prototypeTab";
    private static final String ATTRIBUTE = LaunchConfigurationsMessages.PrototypeTab_Atrribute_label;
    private static final String MODIFIED = LaunchConfigurationsMessages.PrototypeTab_Modified_label;
    private static final String PROTOTYPE_VALUE = LaunchConfigurationsMessages.PrototypeTab_Property_Value_label;
    private ILaunchConfiguration fSelectedLaunchConfiguration;
    private ILaunchConfiguration fAppliedPrototype;
    private Composite fPrototypeComposite;
    private Text fPrototypeText;
    private ControlDecoration fPrototypeTextDecoration;
    private Button fLinkPrototypeButton;
    private Button fUnlinkPrototypeButton;
    private Button fResetPrototypeButton;
    private CheckboxTreeViewer fAttributesTreeViewer;

    public PrototypeTab() {
        this.setHelpContextId("org.eclipse.debug.ui.launch_configuration_dialog_prototype_tab");
    }

    @Override
    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        this.createConfigPrototypeComponent(comp);
        this.createPrototypeExplanationsComponent(comp);
        this.createPrototypeAttributesTreeComponent(comp);
    }

    private void createConfigPrototypeComponent(Composite parent) {
        this.fPrototypeComposite = new Composite(parent, 0);
        this.fPrototypeComposite.setLayout((Layout)new GridLayout(5, false));
        this.fPrototypeComposite.setFont(parent.getFont());
        GridData gd = new GridData(4, 4, true, false);
        this.fPrototypeComposite.setLayoutData((Object)gd);
        SWTFactory.createLabel(this.fPrototypeComposite, LaunchConfigurationsMessages.PrototypeTab_Label_2, 1);
        this.fPrototypeText = SWTFactory.createSingleText(this.fPrototypeComposite, 1);
        this.fPrototypeText.setEditable(false);
        this.fPrototypeTextDecoration = new ControlDecoration((Control)this.fPrototypeText, 16512);
        FieldDecoration errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.fPrototypeTextDecoration.setDescriptionText(LaunchConfigurationsMessages.PrototypeTab_Select_Prototype_Error_7);
        this.fPrototypeTextDecoration.setImage(errorDecoration.getImage());
        this.fLinkPrototypeButton = SWTFactory.createPushButton(this.fPrototypeComposite, LaunchConfigurationsMessages.PrototypeTab_Link_Button_Label_3, null);
        this.fLinkPrototypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PrototypeTab.this.handleLinkPrototypeButtonSelected();
            }
        });
        this.fUnlinkPrototypeButton = SWTFactory.createPushButton(this.fPrototypeComposite, LaunchConfigurationsMessages.PrototypeTab_Unlink_Button_Label_4, null);
        this.fUnlinkPrototypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PrototypeTab.this.handleUnlinkPrototypeButtonSelected();
            }
        });
        this.fResetPrototypeButton = SWTFactory.createPushButton(this.fPrototypeComposite, LaunchConfigurationsMessages.PrototypeTab_Reset_Button_Label_8, null);
        this.fResetPrototypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PrototypeTab.this.handleResetPrototypeButtonSelected();
            }
        });
    }

    private void createPrototypeExplanationsComponent(Composite parent) {
        SWTFactory.createLabel(parent, LaunchConfigurationsMessages.PrototypeTab_Explanation_Label_10, 1);
        SWTFactory.createLabel(parent, LaunchConfigurationsMessages.PrototypeTab_Explanation_Label_11, 1);
    }

    private void createPrototypeAttributesTreeComponent(Composite parent) {
        Composite attributesPrototypeTableComposite = new Composite(parent, 0);
        attributesPrototypeTableComposite.setLayout((Layout)new GridLayout(1, false));
        attributesPrototypeTableComposite.setFont(parent.getFont());
        GridData gd = new GridData(4, 4, true, true);
        attributesPrototypeTableComposite.setLayoutData((Object)gd);
        this.fAttributesTreeViewer = this.createCheckboxTreeViewer(attributesPrototypeTableComposite);
    }

    private void updateProductDecorator() {
        if (this.fAppliedPrototype != null && !this.fAppliedPrototype.exists()) {
            this.fPrototypeTextDecoration.show();
        } else {
            this.fPrototypeTextDecoration.hide();
        }
    }

    private void handleLinkPrototypeButtonSelected() {
        String currentSelectedPrototypeString = this.fPrototypeText.getText();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)DebugUITools.newDebugModelPresentation(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementListSelectionDialog selectPrototypeDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        try {
            Object selectedPrototype;
            ILaunchConfigurationType type = this.fSelectedLaunchConfiguration.getType();
            Object[] prototypes = type.getPrototypes();
            selectPrototypeDialog.setElements(prototypes);
            selectPrototypeDialog.setMultipleSelection(false);
            selectPrototypeDialog.setTitle(LaunchConfigurationsMessages.PrototypeTab_Select_Message_5);
            selectPrototypeDialog.setEmptySelectionMessage(LaunchConfigurationsMessages.PrototypeTab_Select_Empty_Message_6);
            selectPrototypeDialog.setInitialSelections(this.getPrototype((ILaunchConfiguration[])prototypes, currentSelectedPrototypeString));
            int open = selectPrototypeDialog.open();
            if (open == 0 && (selectedPrototype = selectPrototypeDialog.getFirstResult()) instanceof ILaunchConfiguration) {
                this.fAppliedPrototype = (ILaunchConfiguration)selectedPrototype;
                ILaunchConfigurationWorkingCopy workingCopy = this.getWorkingCopy();
                workingCopy.setPrototype(this.fAppliedPrototype, true);
                this.fPrototypeText.setText(((ILaunchConfiguration)selectedPrototype).getName());
                this.fAttributesTreeViewer.setInput((Object)this.fAppliedPrototype);
                this.fUnlinkPrototypeButton.setEnabled(true);
                this.fResetPrototypeButton.setEnabled(true);
                this.updateColumnsWidth();
                this.updateProductDecorator();
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
                this.reinitTabs((ILaunchConfiguration)workingCopy);
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
    }

    private void handleUnlinkPrototypeButtonSelected() {
        try {
            this.fAppliedPrototype = null;
            ILaunchConfigurationWorkingCopy workingCopy = this.getWorkingCopy();
            workingCopy.setPrototype(null, false);
            this.fPrototypeText.setText("");
            this.fAttributesTreeViewer.setInput(null);
            this.fUnlinkPrototypeButton.setEnabled(false);
            this.fResetPrototypeButton.setEnabled(false);
            this.updateProductDecorator();
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
            this.reinitTabs((ILaunchConfiguration)workingCopy);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
    }

    private void handleResetPrototypeButtonSelected() {
        try {
            ILaunchConfigurationWorkingCopy workingCopy = this.getWorkingCopy();
            workingCopy.setPrototype(this.fAppliedPrototype, true);
            this.fAttributesTreeViewer.refresh();
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
            this.reinitTabs((ILaunchConfiguration)workingCopy);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
    }

    private ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = this.fSelectedLaunchConfiguration instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)this.fSelectedLaunchConfiguration : this.fSelectedLaunchConfiguration.getWorkingCopy();
        return workingCopy;
    }

    private void reinitTabs(ILaunchConfiguration launchConfiguration) {
        ILaunchConfigurationTab[] tabs;
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = this.getLaunchConfigurationDialog().getTabs();
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab configTab = iLaunchConfigurationTabArray[n2];
            configTab.initializeFrom(launchConfiguration);
            ++n2;
        }
    }

    private Object[] getPrototype(ILaunchConfiguration[] prototypes, String name) {
        ILaunchConfiguration[] iLaunchConfigurationArray = prototypes;
        int n = prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration prototype = iLaunchConfigurationArray[n2];
            if (name.equals(prototype.getName())) {
                return new Object[]{prototype};
            }
            ++n2;
        }
        return new Object[0];
    }

    private CheckboxTreeViewer createCheckboxTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, 802);
        GridData gd = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)gd);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        CheckboxTreeViewer treeViewer = new CheckboxTreeViewer(tree);
        treeViewer.setContentProvider((IContentProvider)new PrototypeAttributesContentProvider());
        treeViewer.setCheckStateProvider((ICheckStateProvider)new AttributesTreeCheckStateProvider());
        treeViewer.addCheckStateListener((ICheckStateListener)new AttributesTreeCheckStateListener());
        MenuManager menuMgr = new MenuManager();
        Menu contextMenu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener((IMenuListener)new ResetMenuListener());
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(contextMenu);
        return treeViewer;
    }

    private void addColumnsToTreeViewer(CheckboxTreeViewer treeViewer) {
        TreeColumn[] treeColumnArray = treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            treeColumn.dispose();
            ++n2;
        }
        TreeViewerColumn columnLabel = new TreeViewerColumn((TreeViewer)treeViewer, 16384, 0);
        columnLabel.setLabelProvider((CellLabelProvider)new ColumnAttributeLabelProvider());
        columnLabel.getColumn().setText(ATTRIBUTE);
        if (this.fSelectedLaunchConfiguration != null && !this.fSelectedLaunchConfiguration.isPrototype()) {
            TreeViewerColumn columnModified = new TreeViewerColumn((TreeViewer)treeViewer, 0x1000000, 1);
            columnModified.setLabelProvider((CellLabelProvider)new ColumnModifiedLabelProvider());
            columnModified.getColumn().setText(MODIFIED);
        }
        TreeViewerColumn columnValue = new TreeViewerColumn((TreeViewer)treeViewer, 16384, this.fSelectedLaunchConfiguration != null && !this.fSelectedLaunchConfiguration.isPrototype() ? 2 : 1);
        columnValue.setLabelProvider((CellLabelProvider)new ColumnValueLabelProvider());
        columnValue.getColumn().setText(PROTOTYPE_VALUE);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initialize(configuration);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.initialize((ILaunchConfiguration)workingCopy);
    }

    @Override
    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private void initialize(ILaunchConfiguration configuration) {
        try {
            if (configuration.isPrototype()) {
                this.fPrototypeComposite.setVisible(false);
                GridData gridData = (GridData)this.fPrototypeComposite.getLayoutData();
                gridData.exclude = true;
                this.fAppliedPrototype = configuration;
                this.fSelectedLaunchConfiguration = configuration;
                this.addColumnsToTreeViewer(this.fAttributesTreeViewer);
                this.fAttributesTreeViewer.setInput((Object)this.fAppliedPrototype);
                this.fAttributesTreeViewer.getTree().setEnabled(true);
            } else {
                this.fPrototypeComposite.setVisible(true);
                GridData gridData = (GridData)this.fPrototypeComposite.getLayoutData();
                gridData.exclude = false;
                this.fSelectedLaunchConfiguration = configuration;
                this.fAppliedPrototype = configuration.getPrototype();
                this.addColumnsToTreeViewer(this.fAttributesTreeViewer);
                this.fAttributesTreeViewer.getTree().setEnabled(false);
                if (this.fAppliedPrototype == null) {
                    this.fPrototypeText.setText("");
                    this.fUnlinkPrototypeButton.setEnabled(false);
                    this.fResetPrototypeButton.setEnabled(false);
                    this.fAttributesTreeViewer.setInput(null);
                } else if (!this.fAppliedPrototype.exists()) {
                    this.fPrototypeText.setText(this.fAppliedPrototype.getName());
                    this.fUnlinkPrototypeButton.setEnabled(true);
                    this.fResetPrototypeButton.setEnabled(true);
                    this.fAttributesTreeViewer.setInput(null);
                } else {
                    this.fPrototypeText.setText(this.fAppliedPrototype.getName());
                    this.fUnlinkPrototypeButton.setEnabled(true);
                    this.fResetPrototypeButton.setEnabled(true);
                    this.fAttributesTreeViewer.setInput((Object)this.fAppliedPrototype);
                }
            }
            this.updateProductDecorator();
            this.updateColumnsWidth();
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
    }

    private void updateColumnsWidth() {
        this.getShell().getDisplay().asyncExec(() -> {
            Tree tree = this.fAttributesTreeViewer.getTree();
            if (tree != null && !tree.isDisposed()) {
                TreeColumn[] columns;
                TreeColumn[] treeColumnArray = columns = tree.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn treeColumn = treeColumnArray[n2];
                    treeColumn.pack();
                    ++n2;
                }
            }
        });
    }

    @Override
    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.fAppliedPrototype != null && !this.fAppliedPrototype.exists()) {
            this.setErrorMessage(LaunchConfigurationsMessages.PrototypeTab_Select_Prototype_Error_7);
            return false;
        }
        return !config.isPrototype();
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    @Override
    public void postApply() {
        super.postApply();
        ILaunchConfigurationDialog launchConfigurationDialog = this.getLaunchConfigurationDialog();
        if (launchConfigurationDialog instanceof LaunchConfigurationsDialog) {
            ((LaunchConfigurationsDialog)launchConfigurationDialog).refreshLaunchConfigurationView();
        }
    }

    @Override
    public String getName() {
        return LaunchConfigurationsMessages.PrototypeTab_Prototype_1;
    }

    @Override
    public Image getImage() {
        return DebugUITools.getImage("IMG_OBJS_PROTO_TAB");
    }

    @Override
    public String getId() {
        return PROTOTYPE_TAB_ID;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    private boolean isAttributeModified(Map.Entry<String, Object> element) {
        try {
            if (this.fSelectedLaunchConfiguration != null && !this.fSelectedLaunchConfiguration.isPrototype()) {
                return this.fSelectedLaunchConfiguration.isAttributeModified(element.getKey());
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
        return false;
    }

    private class AttributesTreeCheckStateListener
    implements ICheckStateListener {
        private AttributesTreeCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            try {
                Object data = event.getElement();
                if (data instanceof Map.Entry) {
                    PrototypeTab.this.fAppliedPrototype.setPrototypeAttributeVisibility((String)((Map.Entry)data).getKey(), event.getChecked());
                    PrototypeTab.this.setDirty(true);
                    PrototypeTab.this.updateLaunchConfigurationDialog();
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
            }
        }
    }

    private class AttributesTreeCheckStateProvider
    implements ICheckStateProvider {
        private AttributesTreeCheckStateProvider() {
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public boolean isChecked(Object element) {
            try {
                if (element instanceof Map.Entry) {
                    return PrototypeTab.this.fAppliedPrototype.getPrototypeVisibleAttributes().contains(((Map.Entry)element).getKey());
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
            }
            return false;
        }
    }

    private class ColumnAttributeLabelProvider
    extends ColumnLabelProvider {
        private ColumnAttributeLabelProvider() {
        }

        public String getText(Object element) {
            ILaunchConfigurationTab[] tabs;
            String key = (String)((Map.Entry)element).getKey();
            ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = PrototypeTab.this.getLaunchConfigurationDialog().getTabs();
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeLabel;
                ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                if (tab instanceof AbstractLaunchConfigurationTab && (attributeLabel = ((AbstractLaunchConfigurationTab)tab).getAttributeLabel(key)) != null) {
                    return attributeLabel;
                }
                ++n2;
            }
            return key;
        }
    }

    private class ColumnModifiedLabelProvider
    extends ColumnLabelProvider {
        private ColumnModifiedLabelProvider() {
        }

        public String getText(Object element) {
            if (PrototypeTab.this.fSelectedLaunchConfiguration != null && !PrototypeTab.this.fSelectedLaunchConfiguration.isPrototype() && element instanceof Map.Entry && PrototypeTab.this.isAttributeModified((Map.Entry)element)) {
                return "true";
            }
            return "false";
        }
    }

    private class ColumnValueLabelProvider
    extends ColumnLabelProvider {
        private ColumnValueLabelProvider() {
        }

        public String getText(Object element) {
            Object value = ((Map.Entry)element).getValue();
            if (value instanceof Boolean) {
                return ((Boolean)value).toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Integer) {
                return value.toString();
            }
            if (value instanceof List) {
                return "[" + ((List)value).stream().collect(Collectors.joining(", ")) + "]";
            }
            if (value instanceof Set) {
                return "[" + ((Set)value).stream().collect(Collectors.joining(", ")) + "]";
            }
            if (value instanceof Map) {
                return "[" + ((Map)value).entrySet().stream().map(i -> "[" + (String)i.getKey() + ", " + (String)i.getValue() + "]").collect(Collectors.joining(", ")) + "]";
            }
            return super.getText(element);
        }
    }

    private static class PrototypeAttributesContentProvider
    implements ITreeContentProvider {
        private PrototypeAttributesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ILaunchConfiguration) {
                try {
                    Map attributes = ((ILaunchConfiguration)inputElement).getAttributes();
                    return attributes.entrySet().toArray();
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e.getStatus());
                }
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class ResetAction
    extends Action {
        private ResetAction() {
        }

        public String getText() {
            return LaunchConfigurationsMessages.PrototypeTab_Reset_Menu_Action_9;
        }

        public void run() {
            ITreeSelection selection = PrototypeTab.this.fAttributesTreeViewer.getStructuredSelection();
            try {
                ILaunchConfigurationWorkingCopy workingCopy = PrototypeTab.this.getWorkingCopy();
                for (Object element : selection.toList()) {
                    if (!(element instanceof Map.Entry)) continue;
                    String key = (String)((Map.Entry)element).getKey();
                    if (!PrototypeTab.this.fAppliedPrototype.getPrototypeVisibleAttributes().contains(key)) continue;
                    Object prototypeValue = PrototypeTab.this.fAppliedPrototype.getAttributes().get(key);
                    workingCopy.setAttribute(key, prototypeValue);
                }
                PrototypeTab.this.setDirty(true);
                PrototypeTab.this.updateLaunchConfigurationDialog();
                PrototypeTab.this.reinitTabs((ILaunchConfiguration)workingCopy);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
            }
        }
    }

    private class ResetMenuListener
    implements IMenuListener {
        private ResetMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            if (PrototypeTab.this.fSelectedLaunchConfiguration != null && !PrototypeTab.this.fSelectedLaunchConfiguration.isPrototype()) {
                manager.add((IAction)new ResetAction());
            }
        }
    }
}

