/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.Objects;
import org.eclipse.core.resources.IMarker;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class VersionMatchResolution
extends AbstractManifestMarkerResolution {
    public VersionMatchResolution(int type, IMarker marker) {
        super(type, marker);
    }

    @Override
    protected void createChange(BundleModel model) {
        String bundleId = Objects.requireNonNull(this.marker.getAttribute("bundleId", null));
        Bundle bundle = (Bundle)model.getBundle();
        RequireBundleHeader header = (RequireBundleHeader)bundle.getManifestHeader("Require-Bundle");
        if (header != null) {
            RequireBundleObject[] requireBundleObjectArray = header.getRequiredBundles();
            int n = requireBundleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase modelBase;
                RequireBundleObject requiredBundle = requireBundleObjectArray[n2];
                if (bundleId.equals(requiredBundle.getId()) && (modelBase = PluginRegistry.findModel((String)bundleId)) != null) {
                    String version = modelBase.getPluginBase().getVersion();
                    version = VersionUtil.computeInitialPluginVersion((String)version);
                    requiredBundle.setVersion(version);
                }
                ++n2;
            }
        }
    }

    public String getLabel() {
        return PDEUIMessages.AddMatchingVersion_RequireBundle;
    }
}

