/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoverySelector;

final class DeclaredMethodSelector
implements DiscoverySelector {
    private final List<Class<?>> testClasses;
    private final Method method;

    DeclaredMethodSelector(List<Class<?>> testClasses, Method method) {
        Preconditions.notEmpty(testClasses, (String)"testClasses must not be empty");
        this.testClasses = (List)Preconditions.containsNoNullElements(testClasses, (String)"testClasses must not contain null elements");
        this.method = (Method)Preconditions.notNull((Object)method, (String)"method must not be null");
    }

    List<Class<?>> testClasses() {
        return this.testClasses;
    }

    Method method() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeclaredMethodSelector)) {
            return false;
        }
        DeclaredMethodSelector that = (DeclaredMethodSelector)o;
        return Objects.equals(this.testClasses, that.testClasses) && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.testClasses, this.method);
    }
}

