/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogQuery;
import org.eclipse.datatools.enablement.ibm.util.PersistentResultSet;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class QueryExecutionJob
extends Job {
    private ICatalogQuery query;
    private ICatalogObject object;
    private boolean waitUntilFinished;

    public QueryExecutionJob(String name, ICatalogQuery query, ICatalogObject catalogObject) {
        super(name);
        this.setSystem(true);
        this.query = query;
        this.object = catalogObject;
        this.waitUntilFinished = false;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Database database = this.object.getCatalogDatabase();
        String context = "Query Execution Job";
        Connection connection = this.object.getConnection();
        PersistentResultSet resultSet = new PersistentResultSet(database, context, connection, this.query);
        try {
            resultSet.next();
        }
        catch (SQLException sQLException) {}
        if (this.waitUntilFinished) {
            resultSet.completeQueryProcessing();
        }
        return Status.OK_STATUS;
    }

    public void waitUntilFinished() {
        this.waitUntilFinished = true;
    }
}

