/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import org.eclipse.jem.internal.proxy.initParser.Expression;

public class StringLiteral
extends Expression {
    protected boolean isComplete;
    public String value;
    public StringBuffer valueBuffer = new StringBuffer();
    protected boolean isEscaped = false;

    @Override
    public Object evaluate() {
        return this.valueBuffer.toString();
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public Class getTypeClass() {
        return String.class;
    }

    @Override
    protected String getTypeClassName() {
        return String.class.getName();
    }

    @Override
    public Expression push(char[] token, char delimiter) {
        int appendTokenStart = 0;
        int appendTokenLength = token.length;
        if (this.isEscaped) {
            this.isEscaped = false;
            if (token.length != 0) {
                char c = token[0];
                switch (c) {
                    case 'b': {
                        this.valueBuffer.append('\b');
                        appendTokenStart = 1;
                        --appendTokenLength;
                        break;
                    }
                    case 't': {
                        this.valueBuffer.append('\t');
                        appendTokenStart = 1;
                        --appendTokenLength;
                        break;
                    }
                    case 'n': {
                        this.valueBuffer.append('\n');
                        appendTokenStart = 1;
                        --appendTokenLength;
                        break;
                    }
                    case 'r': {
                        this.valueBuffer.append('\r');
                        appendTokenStart = 1;
                        --appendTokenLength;
                        break;
                    }
                    case 'u': {
                        if (appendTokenLength < 5) break;
                        this.valueBuffer.append((char)Integer.parseInt(new String(token, 1, 4), 16));
                        appendTokenStart = 5;
                        appendTokenLength -= 5;
                    }
                }
                if (appendTokenStart == 0) {
                    this.valueBuffer.append('\\');
                }
            } else {
                if (delimiter == '\"' || delimiter == '\\' || delimiter == '\'') {
                    this.valueBuffer.append(delimiter);
                } else {
                    this.valueBuffer.append('\\');
                    this.valueBuffer.append(delimiter);
                }
                return this;
            }
        }
        if (appendTokenLength > 0) {
            this.valueBuffer.append(token, appendTokenStart, appendTokenLength);
        }
        if (delimiter == '\"') {
            this.isComplete = true;
            return this;
        }
        if (delimiter == '\\') {
            this.isEscaped = true;
        } else {
            this.valueBuffer.append(delimiter);
        }
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("String(\"");
        if (this.valueBuffer != null) {
            buffer.append(this.valueBuffer.toString());
        }
        buffer.append("\"");
        return buffer.toString();
    }
}

