/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.base.Optional;
import java.util.List;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.core.internal.util.binding.ValidationListener;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.buildship.ui.internal.wizard.project.GradleProjectWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.HelpContextIdProvider;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWizardPage
extends WizardPage {
    private final ProjectImportConfiguration configuration;
    private final List<Property<?>> observedProperties;
    private final String defaultMessage;
    private final UiBuilder.UiBuilderFactory builderFactory;

    protected AbstractWizardPage(String name, String title, String defaultMessage, ProjectImportConfiguration configuration, final List<Property<?>> observedProperties) {
        super(name);
        this.configuration = configuration;
        this.observedProperties = observedProperties;
        this.defaultMessage = defaultMessage;
        this.setTitle(title);
        this.setMessage(defaultMessage);
        this.setImageDescriptor(ImageDescriptor.createFromFile(GradleProjectWizardPage.class, (String)"/icons/full/wizban/wizard.png"));
        this.builderFactory = new UiBuilder.UiBuilderFactory(JFaceResources.getDialogFont());
        ValidationListener listener = new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                if (validationErrorMessage.isPresent()) {
                    AbstractWizardPage.this.setMessage((String)validationErrorMessage.get(), 3);
                } else {
                    Optional<String> otherErrorMessage = this.validateAllObservedProperties();
                    if (!otherErrorMessage.isPresent()) {
                        AbstractWizardPage.this.setMessage(AbstractWizardPage.this.defaultMessage);
                    } else {
                        AbstractWizardPage.this.setMessage((String)otherErrorMessage.get(), 3);
                    }
                }
                AbstractWizardPage.this.setPageComplete(AbstractWizardPage.this.isPageComplete());
            }

            private Optional<String> validateAllObservedProperties() {
                for (Property property : observedProperties) {
                    Optional errorMessage = property.validate();
                    if (!errorMessage.isPresent()) continue;
                    return errorMessage;
                }
                return Optional.absent();
            }
        };
        for (Property<?> property : observedProperties) {
            property.addValidationListener(listener);
        }
    }

    protected ProjectImportConfiguration getConfiguration() {
        return this.configuration;
    }

    protected UiBuilder.UiBuilderFactory getUiBuilderFactory() {
        return this.builderFactory;
    }

    public final void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite pageControl = this.createWizardPageContent(parent);
        this.setControl((Control)pageControl);
    }

    private Composite createWizardPageContent(Composite parent) {
        ScrolledComposite externalRoot = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)externalRoot, 0);
        this.createWidgets(container);
        Point preferredSize = container.computeSize(-1, -1);
        externalRoot.setExpandHorizontal(true);
        externalRoot.setExpandVertical(true);
        externalRoot.setMinSize(preferredSize);
        externalRoot.setContent((Control)container);
        return externalRoot;
    }

    protected abstract void createWidgets(Composite var1);

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.getWizard() instanceof HelpContextIdProvider) {
            String helpContextId = ((HelpContextIdProvider)this.getWizard()).getHelpContextId();
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), helpContextId);
        }
    }

    public boolean isPageComplete() {
        for (Property<?> property : this.observedProperties) {
            if (property.isValid()) continue;
            return false;
        }
        return true;
    }
}

