/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;

public abstract class AbstractXSLPreferencePage
extends AbstractPreferencePage {
    private final String SETTINGS_EXPANDED = String.valueOf(((Object)((Object)this)).getClass().getCanonicalName()) + ".SETTINGS_EXPANDED";
    private final String SETTINGS_SECTION_NAME = String.valueOf(((Object)((Object)this)).getClass().getCanonicalName()) + ".SETTINGS_SECTION_NAME";
    private List<ExpandableComposite> fExpandables = new ArrayList<ExpandableComposite>();

    protected final Control createContents(Composite parent) {
        this.createCommonContents(parent);
        this.loadPreferences();
        this.restoreSectionExpansionStates(this.getDialogSettings().getSection(this.SETTINGS_SECTION_NAME));
        return parent;
    }

    protected abstract Composite createCommonContents(Composite var1);

    protected Composite createTwistie(Composite parent, String label, int cols) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, cols, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AbstractXSLPreferencePage.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.fExpandables.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        Composite twistieCient = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)twistieCient);
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 5;
        twistieCient.setLayout((Layout)layout);
        GridData gd = new GridData(4, 0, true, false);
        twistieCient.setLayoutData((Object)gd);
        return twistieCient;
    }

    private final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected Combo createCombo(Composite parent, String label, String prefKey) {
        GridData gd = new GridData(4, 2, true, false, 1, 1);
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo combo = this.createDropDownBox(parent);
        combo.addSelectionListener((SelectionListener)this);
        combo.setLayoutData((Object)new GridData(256));
        return combo;
    }

    private void storeSectionExpansionStates(IDialogSettings section) {
        int i = 0;
        while (i < this.fExpandables.size()) {
            ExpandableComposite comp = this.fExpandables.get(i);
            section.put(String.valueOf(this.SETTINGS_EXPANDED) + String.valueOf(i), comp.isExpanded());
            ++i;
        }
    }

    private IDialogSettings getDialogSettings() {
        return XSLUIPlugin.getDefault().getDialogSettings();
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogSettings().addNewSection(this.SETTINGS_SECTION_NAME));
        super.dispose();
    }

    private void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandables.size()) {
            ExpandableComposite excomposite = this.fExpandables.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(String.valueOf(this.SETTINGS_EXPANDED) + String.valueOf(i)));
            }
            ++i;
        }
    }

    protected Preferences getModelPreferences() {
        return XSLCorePlugin.getDefault().getPluginPreferences();
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (ok) {
            XSLCorePlugin.getDefault().savePluginPreferences();
        }
        return ok;
    }
}

