/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Vector;

class FileFilterImpl
implements FileFilter {
    private String extension;
    private File root;
    private Vector fileVector = new Vector();

    public FileFilterImpl(String root, String extension) throws IOException {
        this.root = new File(root);
        if (!this.root.isDirectory()) {
            this.root = null;
            throw new IOException("Not a directory: " + this.root);
        }
        this.extension = extension;
    }

    @Override
    public boolean accept(File pathname) {
        String filename;
        if (pathname.isDirectory()) {
            pathname.listFiles(this);
        }
        if ((filename = pathname.getName()).substring(filename.lastIndexOf(".") + 1).equals(this.extension) && !pathname.isDirectory()) {
            this.fileVector.add(pathname);
            return true;
        }
        return false;
    }

    public File[] getFiles() {
        this.root.listFiles(this);
        return this.getFileList();
    }

    private File[] getFileList() {
        Object[] fileList = new File[this.fileVector.size()];
        this.fileVector.copyInto(fileList);
        return fileList;
    }
}

