/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui;

import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public abstract class AbstractShiftedListSection {
    protected List _leftList;
    protected List _rightList;
    protected Button _left2RightButton;
    protected Button _left2RightAllButton;
    protected Button _right2LeftButton;
    protected Button _right2LeftAllButton;
    protected Button _upMoveButton;
    protected Button _downMoveButton;
    protected String _groupTitle;
    protected String _leftListTitle;
    protected String _rightListTitle;
    protected String _left2Right;
    protected String _left2RightAll;
    protected String _right2Left;
    protected String _right2LeftAll;
    protected String _moveUp;
    protected String _moveDown;
    static final int BUTTON_WIDTH = 80;

    public AbstractShiftedListSection(String sectionTitle, String leftTitle, String rightTitle) {
        this._groupTitle = sectionTitle;
        this._leftListTitle = leftTitle;
        this._rightListTitle = rightTitle;
    }

    public Control createContents(Composite parent) {
        Group columnsComp = new Group(parent, 0);
        GridData gd = new GridData(1808);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        columnsComp.setLayout((Layout)layout);
        columnsComp.setLayoutData((Object)gd);
        columnsComp.setText(this._groupTitle);
        Composite selectedComposite = new Composite((Composite)columnsComp, 0);
        gd = new GridData(1808);
        selectedComposite.setLayoutData((Object)gd);
        layout = new GridLayout();
        selectedComposite.setLayout((Layout)layout);
        Label selectedPages = new Label(selectedComposite, 0);
        selectedPages.setText(this._leftListTitle);
        gd = new GridData();
        gd.horizontalAlignment = 32;
        selectedPages.setLayoutData((Object)gd);
        this._leftList = new List(selectedComposite, 2050);
        gd = new GridData(1808);
        this._leftList.setLayoutData((Object)gd);
        Composite buttonsComp = new Composite((Composite)columnsComp, 0);
        gd = new GridData(1040);
        buttonsComp.setLayoutData((Object)gd);
        layout = new GridLayout();
        buttonsComp.setLayout((Layout)layout);
        this.setShiftButtonText();
        GC gc = new GC((Drawable)buttonsComp);
        int maxShiftButtonsWidth = this.computeMaxShiftButtonsWidth(gc);
        gc.dispose();
        new Label(buttonsComp, 0);
        this._left2RightButton = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxShiftButtonsWidth;
        this._left2RightButton.setLayoutData((Object)gd);
        this._left2RightButton.setText(this._left2Right);
        this._left2RightButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractShiftedListSection.this.shiftToRightAction();
            }
        });
        this._left2RightAllButton = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxShiftButtonsWidth;
        this._left2RightAllButton.setLayoutData((Object)gd);
        this._left2RightAllButton.setText(this._left2RightAll);
        this._left2RightAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractShiftedListSection.this.shiftAllToRightAction();
            }
        });
        this._right2LeftButton = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxShiftButtonsWidth;
        this._right2LeftButton.setLayoutData((Object)gd);
        this._right2LeftButton.setText(this._right2Left);
        this._right2LeftButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractShiftedListSection.this.shiftToLeftAction();
            }
        });
        this._right2LeftAllButton = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxShiftButtonsWidth;
        this._right2LeftAllButton.setLayoutData((Object)gd);
        this._right2LeftAllButton.setText(this._right2LeftAll);
        this._right2LeftAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractShiftedListSection.this.shiftAllToLeftAction();
            }
        });
        this._upMoveButton = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxShiftButtonsWidth;
        this._upMoveButton.setLayoutData((Object)gd);
        this._upMoveButton.setText(this._moveUp);
        this._upMoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractShiftedListSection.this.moveUpAction();
            }
        });
        this._downMoveButton = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxShiftButtonsWidth;
        this._downMoveButton.setLayoutData((Object)gd);
        this._downMoveButton.setText(this._moveDown);
        this._downMoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractShiftedListSection.this.moveDownAction();
            }
        });
        Composite availableComp = new Composite((Composite)columnsComp, 0);
        gd = new GridData(1808);
        availableComp.setLayoutData((Object)gd);
        layout = new GridLayout();
        availableComp.setLayout((Layout)layout);
        Label availablePages = new Label(availableComp, 0);
        availablePages.setText(this._rightListTitle);
        gd = new GridData();
        gd.horizontalAlignment = 32;
        availablePages.setLayoutData((Object)gd);
        this._rightList = new List(availableComp, 2050);
        gd = new GridData(1808);
        this._rightList.setLayoutData((Object)gd);
        this._leftList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractShiftedListSection.this._rightList.deselectAll();
                AbstractShiftedListSection.this.setButtonStatus();
            }
        });
        this._rightList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractShiftedListSection.this._leftList.deselectAll();
                AbstractShiftedListSection.this.setButtonStatus();
            }
        });
        this.setButtonStatus();
        return parent;
    }

    public void setInput(String[] leftItems, String[] rightItems, boolean reset) {
        if (reset) {
            this._leftList.removeAll();
            this._rightList.removeAll();
        }
        int i = 0;
        while (leftItems != null && i < leftItems.length) {
            this._leftList.add(leftItems[i]);
            this._leftList.setData(leftItems[i], (Object)i);
            ++i;
        }
        i = 0;
        while (rightItems != null && i < rightItems.length) {
            this._rightList.add(rightItems[i]);
            this._rightList.setData(rightItems[i], (Object)-1);
            ++i;
        }
        this.setButtonStatus();
    }

    private void computeLeftData() {
        String[] selectedItems = this._leftList.getItems();
        int i = 0;
        while (i < selectedItems.length) {
            String name = selectedItems[i];
            this._leftList.setData(name, (Object)i);
            ++i;
        }
    }

    private int computeMaxShiftButtonsWidth(GC gc) {
        int maxWidth = 0;
        maxWidth = this.getGreaterWidth(gc, this._left2Right, maxWidth);
        maxWidth = this.getGreaterWidth(gc, this._left2RightAll, maxWidth);
        maxWidth = this.getGreaterWidth(gc, this._right2Left, maxWidth);
        maxWidth = this.getGreaterWidth(gc, this._right2LeftAll, maxWidth);
        maxWidth = this.getGreaterWidth(gc, this._moveUp, maxWidth);
        maxWidth = this.getGreaterWidth(gc, this._moveDown, maxWidth);
        return maxWidth;
    }

    private int getGreaterWidth(GC gc, String str, int compareWidth) {
        int greaterWidth = compareWidth;
        Point strExtentPoint = gc.stringExtent(str);
        int strWidth = strExtentPoint.x;
        if (strWidth > compareWidth) {
            greaterWidth = strWidth;
        }
        return greaterWidth;
    }

    private void moveItem(List list, boolean upDirection) {
        if (list.getItemCount() == 0 || list.getSelectionCount() != 1 || list.getSelectionIndex() == 0 && upDirection || list.getSelectionIndex() == list.getItemCount() - 1 && !upDirection) {
            return;
        }
        int selectionIndex = list.getSelectionIndex();
        String selectionItem = list.getItem(selectionIndex);
        if (upDirection) {
            list.add(selectionItem, selectionIndex - 1);
            list.remove(selectionIndex + 1);
            list.select(selectionIndex - 1);
        } else {
            list.add(selectionItem, selectionIndex + 2);
            list.remove(selectionIndex);
            list.select(selectionIndex + 1);
        }
        this.setButtonStatus();
    }

    private void setButtonStatus() {
        if (this._leftList.getSelectionCount() > 0) {
            this._left2RightButton.setEnabled(true);
            if (this._leftList.getSelectionCount() == 1 && this._leftList.getSelectionIndex() != 0) {
                this._upMoveButton.setEnabled(true);
            } else {
                this._upMoveButton.setEnabled(false);
            }
            if (this._leftList.getSelectionCount() == 1 && this._leftList.getSelectionIndex() != this._leftList.getItemCount() - 1) {
                this._downMoveButton.setEnabled(true);
            } else {
                this._downMoveButton.setEnabled(false);
            }
        } else {
            this._left2RightButton.setEnabled(false);
            this._upMoveButton.setEnabled(false);
            this._downMoveButton.setEnabled(false);
        }
        if (this._rightList.getSelectionCount() > 0) {
            this._right2LeftButton.setEnabled(true);
        } else {
            this._right2LeftButton.setEnabled(false);
        }
        if (this._leftList.getItemCount() > 0) {
            this._left2RightAllButton.setEnabled(true);
        } else {
            this._left2RightAllButton.setEnabled(false);
        }
        if (this._rightList.getItemCount() > 0) {
            this._right2LeftAllButton.setEnabled(true);
        } else {
            this._right2LeftAllButton.setEnabled(false);
        }
    }

    protected void shiftToRightAction() {
        String[] selectedItems = this._leftList.getSelection();
        int movedNum = 0;
        int i = 0;
        while (i < selectedItems.length) {
            String name = selectedItems[i];
            this._rightList.add(name);
            this._rightList.setData(name, (Object)-1);
            this._leftList.remove(name);
            ++movedNum;
            ++i;
        }
        this.computeLeftData();
        this._leftList.deselectAll();
        int[] indecies = new int[movedNum];
        int i2 = 0;
        while (i2 < movedNum) {
            indecies[i2] = this._rightList.getItemCount() - 1 - i2;
            ++i2;
        }
        this._rightList.setSelection(indecies);
        this.setButtonStatus();
    }

    protected void shiftAllToRightAction() {
        String[] selectedItems = this._leftList.getItems();
        int i = 0;
        while (i < selectedItems.length) {
            String name = selectedItems[i];
            this._rightList.add(name);
            this._rightList.setData(name, (Object)-1);
            this._leftList.remove(name);
            ++i;
        }
        this.setButtonStatus();
    }

    protected void shiftToLeftAction() {
        String[] selectedItems = this._rightList.getSelection();
        int movedNum = 0;
        int i = 0;
        while (i < selectedItems.length) {
            String name = selectedItems[i];
            this._leftList.add(name);
            this._rightList.remove(name);
            ++movedNum;
            ++i;
        }
        this.computeLeftData();
        int[] indecies = new int[movedNum];
        int i2 = 0;
        while (i2 < movedNum) {
            indecies[i2] = this._leftList.getItemCount() - 1 - i2;
            ++i2;
        }
        this._leftList.setSelection(indecies);
        this.setButtonStatus();
    }

    protected void shiftAllToLeftAction() {
        String[] selectedItems = this._rightList.getItems();
        int i = 0;
        while (i < selectedItems.length) {
            String name = selectedItems[i];
            this._leftList.add(name);
            this._rightList.remove(name);
            ++i;
        }
        this.computeLeftData();
        this.setButtonStatus();
    }

    protected void moveUpAction() {
        this.moveItem(this._leftList, true);
        this.computeLeftData();
    }

    protected void moveDownAction() {
        this.moveItem(this._leftList, false);
        this.computeLeftData();
    }

    protected void setShiftButtonText() {
        this._left2Right = Messages.ShiftListMoveRight;
        this._left2RightAll = Messages.ShiftListMoveRightAll;
        this._right2Left = Messages.ShiftListMoveLeft;
        this._right2LeftAll = Messages.ShiftListMoveLeftAll;
        this._moveUp = Messages.ShiftListMoveUp;
        this._moveDown = Messages.ShiftListMoveDown;
    }
}

