/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.deque.Deque;

public class ListDeque<E>
implements Deque<E>,
Serializable {
    private List<E> list;
    private static final long serialVersionUID = 1L;

    public ListDeque(List<E> list) {
        this.list = list;
    }

    @Override
    public void enqueueTail(E element) {
        this.list.add(element);
    }

    @Override
    public void enqueueHead(E element) {
        this.list.add(0, element);
    }

    @Override
    public E dequeueHead() {
        if (this.list.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.list.remove(0);
    }

    @Override
    public E dequeueTail() {
        int size = this.list.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.list.remove(size - 1);
    }

    @Override
    public E peekHead() {
        if (this.list.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.list.get(0);
    }

    @Override
    public E peekTail() {
        int size = this.list.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.list.get(size - 1);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return this.list.toString();
    }
}

