/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.exportmodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.modulecore.AddClasspathFoldersParticipant;
import org.eclipse.jst.common.internal.modulecore.AddClasspathLibReferencesParticipant;
import org.eclipse.jst.common.internal.modulecore.AddClasspathLibRefsProviderParticipant;
import org.eclipse.jst.common.internal.modulecore.ReplaceManifestExportParticipant;
import org.eclipse.jst.common.internal.modulecore.SingleRootExportParticipant;
import org.eclipse.jst.common.internal.modulecore.SingleRootUtil;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyEnablement;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.flat.FilterResourceParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.GlobalHeirarchyParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaEESingleRootCallback
implements SingleRootExportParticipant.SingleRootParticipantCallback {
    public static final int UNNECESSARY_RESOURCE_MAP = 100;
    public static final int EAR_PROJECT_FOUND = 10100;
    public static final int ATLEAST_1_RESOURCE_MAP_MISSING = 10101;
    public static final int JAVA_OUTPUT_NOT_WEBINF_CLASSES = 10102;
    public static final int RUNTIME_PATH_NOT_ROOT_OR_WEBINF_CLASSES = 10103;
    public static final int ONLY_1_CONTENT_ROOT_ALLOWED = 10104;
    public static final int ONE_CONTENT_ROOT_REQUIRED = 10105;
    public static final int ATLEAST_1_JAVA_SOURCE_REQUIRED = 10106;
    public static final int CLASSPATH_DEPENDENCIES_FOUND = 10107;
    public static final int SOURCE_PATH_OUTSIDE_CONTENT_ROOT = 10108;
    private static final int CANCEL = 0;
    private String[] filteredSuffixes = new String[0];

    public JavaEESingleRootCallback() {
    }

    public JavaEESingleRootCallback(String[] filtered) {
        this.filteredSuffixes = filtered;
    }

    public void setFilteredSuffixes(String[] filtered) {
        this.filteredSuffixes = filtered;
    }

    public boolean canValidate(IVirtualComponent vc) {
        return JavaEEProjectUtilities.usesJavaEEComponent(vc);
    }

    public void validate(SingleRootUtil util, IVirtualComponent vc, IProject project, List resourceMaps) {
        IResource sourceResource;
        ComponentResource mapping;
        if (resourceMaps.size() == 1 && util.isRootMapping(mapping = (ComponentResource)resourceMaps.get(0)) && (sourceResource = project.findMember(mapping.getSourcePath())) != null && sourceResource.exists() && sourceResource instanceof IContainer && !util.isSourceContainer((IContainer)sourceResource)) {
            util.reportStatus(1, (IContainer)sourceResource);
            util.setValidateFlag(0);
            return;
        }
        if (JavaEEProjectUtilities.isEARProject(project)) {
            this.validateEARProject(util, vc, resourceMaps);
            util.setValidateFlag(0);
            return;
        }
        if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
            this.validateWebProject(util, vc, resourceMaps);
            util.setValidateFlag(0);
        }
    }

    private void validateEARProject(SingleRootUtil util, IVirtualComponent vc, List resourceMaps) {
        ArrayList<ComponentResource> rootMappings = new ArrayList<ComponentResource>();
        ArrayList<ComponentResource> nonRootMappings = new ArrayList<ComponentResource>();
        int i = 0;
        while (i < resourceMaps.size()) {
            ComponentResource resourceMap = (ComponentResource)resourceMaps.get(i);
            if (util.isRootMapping(resourceMap)) {
                rootMappings.add(resourceMap);
            } else {
                nonRootMappings.add(resourceMap);
            }
            ++i;
        }
        if (rootMappings.size() > 1) {
            util.reportStatus(10104);
            return;
        }
        if (rootMappings.size() < 1) {
            util.reportStatus(10105);
            return;
        }
        ComponentResource rootMapping = (ComponentResource)rootMappings.get(0);
        boolean reportNonSingleRoot = false;
        for (ComponentResource otherMapping : nonRootMappings) {
            IPath otherMappingSourcePath = otherMapping.getSourcePath();
            if (rootMapping.getSourcePath().isPrefixOf(otherMappingSourcePath)) continue;
            reportNonSingleRoot = true;
            break;
        }
        if (reportNonSingleRoot) {
            util.reportStatus(10108);
            return;
        }
        IResource sourceResource = util.getProject().findMember(((ComponentResource)rootMappings.get(0)).getSourcePath());
        if (sourceResource != null && sourceResource.exists() && sourceResource instanceof IContainer && !util.isSourceContainer((IContainer)sourceResource)) {
            util.reportStatus(1, (IContainer)sourceResource);
            return;
        }
    }

    private void validateWebProject(SingleRootUtil util, IVirtualComponent vc, List resourceMaps) {
        if (this.hasDefaultWebResourceMappings(util, resourceMaps)) {
            IContainer[] javaOutputFolders = util.getJavaOutputFolders();
            if (javaOutputFolders.length == 1) {
                IPath javaOutputPath = util.getJavaOutputFolders()[0].getProjectRelativePath();
                IContainer rootContainer = vc.getRootFolder().getUnderlyingFolder();
                IPath compRootPath = rootContainer.getProjectRelativePath();
                if (compRootPath.append("WEB-INF/classes").equals((Object)javaOutputPath)) {
                    util.reportStatus(1, rootContainer);
                    return;
                }
                util.reportStatus(10102);
            } else {
                util.reportStatus(135);
            }
        }
    }

    private boolean hasDefaultWebResourceMappings(SingleRootUtil util, List resourceMaps) {
        int rootValidMaps = 0;
        IPath pathMappedToContentRoot = null;
        ArrayList<ComponentResource> tmpResources = new ArrayList<ComponentResource>();
        IPath webInfClasses = new Path("WEB-INF/classes").makeAbsolute();
        int i = 0;
        while (i < resourceMaps.size()) {
            ComponentResource resourceMap = (ComponentResource)resourceMaps.get(i);
            IPath sourcePath = resourceMap.getSourcePath();
            IPath runtimePath = resourceMap.getRuntimePath();
            IResource sourceResource = util.getProject().findMember(sourcePath);
            if (util.isRootMapping(resourceMap)) {
                ++rootValidMaps;
                if (pathMappedToContentRoot == null) {
                    pathMappedToContentRoot = sourcePath;
                }
            } else if (runtimePath.equals((Object)webInfClasses)) {
                if (sourceResource != null && sourceResource.exists()) {
                    if (sourceResource instanceof IContainer && !util.isSourceContainer((IContainer)sourceResource)) {
                        util.reportStatus(137, sourcePath);
                    }
                } else {
                    util.reportStatus(33, sourcePath);
                }
            } else {
                tmpResources.add(resourceMap);
            }
            if (util.getValidateFlag() == 0) {
                return false;
            }
            ++i;
        }
        if (pathMappedToContentRoot != null) {
            for (ComponentResource res : tmpResources) {
                IPath completePath = pathMappedToContentRoot.append(res.getRuntimePath());
                if (completePath.equals((Object)res.getSourcePath())) {
                    util.reportStatus(100, res.getSourcePath());
                } else {
                    util.reportStatus(10103, res.getRuntimePath());
                }
                if (util.getValidateFlag() != 0) continue;
                return false;
            }
            tmpResources = null;
        }
        if (rootValidMaps != 1) {
            if (rootValidMaps < 1) {
                util.reportStatus(10105);
            } else if (rootValidMaps > 1) {
                util.reportStatus(10104);
            }
        }
        return util.getValidateFlag() != 0;
    }

    public IFlattenParticipant[] getDelegateParticipants() {
        ArrayList<Object> participants = new ArrayList<Object>();
        participants.add(new GlobalHeirarchyParticipant());
        participants.add(FilterResourceParticipant.createSuffixFilterParticipant((String[])this.filteredSuffixes));
        participants.add(new AddClasspathLibReferencesParticipant());
        participants.add(new AddClasspathLibRefsProviderParticipant());
        participants.add(new AddClasspathFoldersParticipant());
        if (ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
            participants.add(new ReplaceManifestExportParticipant((IPath)new Path("META-INF/MANIFEST.MF")));
        }
        return participants.toArray(new IFlattenParticipant[participants.size()]);
    }
}

