/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.actions;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.BaseSelectionAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.IASDAddCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.dialogs.ImportSelectionDialog;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IImport;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ICategoryAdapter;

public class ASDAddImportAction
extends BaseSelectionAction {
    public static String ID = "ASDAddImportAction";

    public ASDAddImportAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages._UI_ACTION_ADD_IMPORT);
        this.setImageDescriptor(ASDEditorPlugin.getImageDescriptor("icons/import_obj.gif"));
    }

    public void run() {
        if (this.getSelectedObjects().size() > 0) {
            Object o = this.getSelectedObjects().get(0);
            if (o instanceof ICategoryAdapter) {
                o = ((ICategoryAdapter)o).getOwnerDescription();
            }
            if (o instanceof IDescription) {
                ImportSelectionDialog dialog;
                int rc;
                Command command = ((IDescription)o).getAddImportCommand();
                CommandStack stack = (CommandStack)ASDEditorPlugin.getActiveEditor().getAdapter(CommandStack.class);
                stack.execute(command);
                IImport theImport = null;
                if (command instanceof IASDAddCommand) {
                    theImport = (IImport)((IASDAddCommand)command).getNewlyAddedComponent();
                }
                boolean selectLocation = WSDLEditorPlugin.getInstance().getAutoOpenImportLocationDialogSetting();
                if (theImport != null && selectLocation && (rc = (dialog = new ImportSelectionDialog(WSDLEditorPlugin.getShell(), null, true)).open()) == 0) {
                    String locationURI = dialog.getImportLocation();
                    String namespaceURI = dialog.getImportNamespace();
                    Command updateImportCommand = theImport.getUpdateCommand(locationURI, namespaceURI, "");
                    stack.execute(updateImportCommand);
                }
                if (theImport != null) {
                    this.performSelection(theImport);
                }
            }
        }
    }
}

