/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public final class WSIProperties {
    protected static Properties wsiProperties = new Properties();
    public static final String DEF_VALIDATOR_FACTORY = "org.eclipse.wst.wsi.internal.core.profile.validator.impl.ProfileValidatorFactoryImpl";
    public static final String PROP_VALIDATOR_FACTORY = "wsi.profile.validator.factory";
    public static final String DEF_DOCUMENT_FACTORY = "org.eclipse.wst.wsi.internal.core.document.impl.DocumentFactoryImpl";
    public static final String PROP_DOCUMENT_FACTORY = "wsi.document.factory";
    public static final String DEF_JAXP_DOCUMENT_FACTORY = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    public static final String PROP_JAXP_DOCUMENT_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    public static final String DEF_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl/";
    public static final String PROP_WSDL_SCHEMA = "wsi.analyzer.wsdl.schema";
    public static final String DEF_WSDL_SOAP_SCHEMA = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String PROP_WSDL_SOAP_SCHEMA = "wsi.analyzer.wsdlsoap.schema";
    public static final String DEF_WSDL_MIME_SCHEMA = "http://schemas.xmlsoap.org/wsdl/mime/";
    public static final String PROP_WSDL_MIME_SCHEMA = "wsi.analyzer.wsdlmime.schema";
    public static final String DEF_SOAP_SCHEMA = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String PROP_SOAP_SCHEMA = "wsi.analyzer.soap.schema";
    public static final String DEF_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema.xsd";
    public static final String PROP_XML_SCHEMA = "wsi.analyzer.xmlschema.schema";
    public static final String PROP_WSI_HOME = "wsi.home";
    protected static final String PROP_FILENAME = "org.eclipse.wst.wsi.internal.core.util.wsi";
    private static ThreadLocal threadLocal = new ThreadLocal();

    static {
        WSIProperties.loadPropertiesFile();
    }

    private static void loadPropertiesFile() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PROP_FILENAME);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String nextKey = enumeration.nextElement();
                wsiProperties.put(nextKey, resourceBundle.getString(nextKey));
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("WARNING:  Could not read org.eclipse.wst.wsi.internal.core.util.wsi.  Verify that it is in the CLASSPATH.");
            wsiProperties.put(PROP_VALIDATOR_FACTORY, DEF_VALIDATOR_FACTORY);
            wsiProperties.put(PROP_DOCUMENT_FACTORY, DEF_DOCUMENT_FACTORY);
            wsiProperties.put(PROP_JAXP_DOCUMENT_FACTORY, DEF_JAXP_DOCUMENT_FACTORY);
            wsiProperties.put("org.uddi4j.TransportClassName", "org.uddi4j.transport.ApacheAxisTransport");
        }
    }

    private WSIProperties() {
    }

    public static Properties getThreadLocalProperties() {
        return (Properties)threadLocal.get();
    }

    public static void setThreadLocalProperties(Properties props) {
        threadLocal.set(props);
    }

    public static String getProperty(String propertyName) {
        String propertyValue = null;
        Properties threadLocalProps = null;
        threadLocalProps = WSIProperties.getThreadLocalProperties();
        if (threadLocalProps != null) {
            propertyValue = threadLocalProps.getProperty(propertyName);
        }
        if (propertyValue == null) {
            propertyValue = System.getProperty(propertyName);
        }
        if (propertyValue == null) {
            propertyValue = wsiProperties.getProperty(propertyName);
        }
        return propertyValue;
    }

    public static String getProperty(String propertyName, String defaultValue) {
        String propertyValue = null;
        propertyValue = WSIProperties.getProperty(propertyName);
        if (propertyValue == null) {
            propertyValue = defaultValue;
        }
        return propertyValue;
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.setProperty(PROP_VALIDATOR_FACTORY, "main");
            WSIProperties.setThreadLocalProperties(props);
            int i = 0;
            while (i < 5) {
                new Thread(new ThreadTest("test" + i)).start();
                try {
                    Thread.sleep(200L);
                    System.out.println("PROP_VALIDATOR_FACTORY:  " + WSIProperties.getProperty(PROP_VALIDATOR_FACTORY));
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private static class ThreadTest
    extends Thread {
        String name;

        ThreadTest(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            Properties props = new Properties();
            props.setProperty(WSIProperties.PROP_VALIDATOR_FACTORY, this.name);
            WSIProperties.setThreadLocalProperties(props);
            System.out.println("PROP_VALIDATOR_FACTORY:  " + WSIProperties.getProperty(WSIProperties.PROP_VALIDATOR_FACTORY));
        }
    }
}

