/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile;

import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.profile.nls.Messages;

public class ProfileFileExtension {
    public static final String FILE_EXT_SEPARATOR = ".";
    private static final String PROFILE_STORE_EXT_POINT = "org.eclipse.datatools.connectivity.oda.profile.profileStore";
    private static final String FILE_EXT_ELEMENT = "fileExtension";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String EMPTY_STRING = "";
    private static String sm_defaultFileExtension;
    private static final String sm_className;

    static {
        sm_className = ProfileFileExtension.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDefault() {
        if (sm_defaultFileExtension != null) return sm_defaultFileExtension;
        Class<ProfileFileExtension> clazz = ProfileFileExtension.class;
        synchronized (ProfileFileExtension.class) {
            if (sm_defaultFileExtension != null) return sm_defaultFileExtension;
            sm_defaultFileExtension = ProfileFileExtension.loadDefaultFileExtension();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_defaultFileExtension;
        }
    }

    public static boolean exists(String defaultFileExtension) {
        return defaultFileExtension != null && defaultFileExtension.trim().length() > 0;
    }

    private static String loadDefaultFileExtension() {
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(PROFILE_STORE_EXT_POINT);
        if (extPoint == null) {
            return EMPTY_STRING;
        }
        IExtension[] extensions = extPoint.getExtensions();
        if (extensions.length < 1) {
            return EMPTY_STRING;
        }
        if (extensions.length > 1) {
            String warningMsg = Messages.bind((String)Messages.profileFileExtension_MULTIPLE_EXTENSIONS_FOUND, (Object)PROFILE_STORE_EXT_POINT);
            Logger.getLogger(sm_className).warning(warningMsg);
        }
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            if (configElements.length >= 1) {
                int j = 0;
                while (j < configElements.length) {
                    String defaultFileExt;
                    IConfigurationElement configElement = configElements[j];
                    if (configElement.getName().equals(FILE_EXT_ELEMENT) && (defaultFileExt = configElement.getAttribute(DEFAULT_ATTRIBUTE)) != null) {
                        if ((defaultFileExt = defaultFileExt.trim()).startsWith(FILE_EXT_SEPARATOR)) {
                            defaultFileExt = defaultFileExt.substring(FILE_EXT_SEPARATOR.length());
                        }
                        if (defaultFileExt.length() > 0) {
                            Logger.getLogger(sm_className).info(Messages.bind((String)Messages.profileFileExtension_APPLIED_DEFAULT_FILE_EXT, (Object[])new Object[]{defaultFileExt, PROFILE_STORE_EXT_POINT, extensions[i].getContributor().getName()}));
                            return defaultFileExt;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return EMPTY_STRING;
    }
}

