/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.validator.BaseValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.EnvelopeValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.MessageValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.UDDIValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.WSDLValidator;
import org.eclipse.wst.wsi.internal.core.util.WSIProperties;

public abstract class ProfileValidatorFactory {
    public abstract BaseValidator getValidatorForArtifact(String var1) throws WSIException;

    public abstract UDDIValidator newUDDIValidator() throws WSIException;

    public abstract WSDLValidator newWSDLValidator() throws WSIException;

    public abstract MessageValidator newMessageValidator() throws WSIException;

    public abstract EnvelopeValidator newEnvelopeValidator() throws WSIException;

    public static ProfileValidatorFactory newInstance() throws WSIException {
        ProfileValidatorFactory factory = null;
        String factoryClassName = null;
        try {
            factoryClassName = WSIProperties.getProperty("wsi.profile.validator.factory", "org.eclipse.wst.wsi.internal.core.profile.validator.impl.ProfileValidatorFactoryImpl");
            Class<?> factoryClass = Class.forName(factoryClassName);
            factory = (ProfileValidatorFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new WSIException("Could not instantiate factory class: " + factoryClassName + ".", e);
        }
        return factory;
    }
}

