/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP2010
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2010(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        PortType portType = (PortType)entryContext.getEntry().getEntryDetail();
        HashSet<String> namesSeen = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        try {
            List opsList = portType.getOperations();
            if (opsList == null) {
                this.result = "notApplicable";
            } else {
                for (Operation op : opsList) {
                    String opName = op.getName();
                    if (namesSeen.contains(opName)) {
                        duplicates.add(opName);
                        continue;
                    }
                    namesSeen.add(opName);
                }
            }
            if (!duplicates.isEmpty()) {
                StringBuffer failInfo = new StringBuffer("Duplicate operation names in portType " + portType.getQName() + ": ");
                Iterator i = duplicates.iterator();
                while (i.hasNext()) {
                    failInfo.append(String.valueOf((String)i.next()) + "; ");
                }
                throw new AssertionFailException(failInfo.toString());
            }
        }
        catch (NullPointerException nullPointerException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext, portType);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

