/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServerWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat100Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat101Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat110Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat32Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat40Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat41Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat50Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat55Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat60Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat70Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat80Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat85Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat90Configuration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class TomcatServer
extends ServerDelegate
implements ITomcatServer,
ITomcatServerWorkingCopy {
    public static final String PROPERTY_SECURE = "secure";
    public static final String PROPERTY_DEBUG = "debug";
    protected transient TomcatConfiguration configuration;
    protected transient ITomcatVersionHandler versionHandler;
    private int currentVersion;
    private int loadedVersion;
    private Object versionLock = new Object();

    public TomcatRuntime getTomcatRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (TomcatRuntime)this.getServer().getRuntime().loadAdapter(TomcatRuntime.class, null);
    }

    public ITomcatVersionHandler getTomcatVersionHandler() {
        if (this.versionHandler == null) {
            if (this.getServer().getRuntime() == null || this.getTomcatRuntime() == null) {
                return null;
            }
            this.versionHandler = this.getTomcatRuntime().getVersionHandler();
        }
        return this.versionHandler;
    }

    public ITomcatConfiguration getServerConfiguration() throws CoreException {
        return this.getTomcatConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TomcatConfiguration getTomcatConfiguration() throws CoreException {
        TomcatConfiguration tcConfig;
        int current;
        Object object = this.versionLock;
        synchronized (object) {
            current = this.currentVersion;
            tcConfig = this.configuration;
        }
        if (tcConfig == null || this.loadedVersion != current) {
            IFolder folder = this.getServer().getServerConfiguration();
            if (folder == null || !folder.exists()) {
                String path = null;
                if (folder != null) {
                    path = folder.getFullPath().toOSString();
                    IProject project = folder.getProject();
                    if (project != null && project.exists() && !project.isOpen()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorConfigurationProjectClosed, (Object)path, (Object)project.getName()), null));
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorNoConfiguration, (Object)path), null));
            }
            if (tcConfig == null) {
                String id = this.getServer().getServerType().getId();
                if (id.indexOf("32") > 0) {
                    tcConfig = new Tomcat32Configuration(folder);
                } else if (id.indexOf("40") > 0) {
                    tcConfig = new Tomcat40Configuration(folder);
                } else if (id.indexOf("41") > 0) {
                    tcConfig = new Tomcat41Configuration(folder);
                } else if (id.indexOf("50") > 0) {
                    tcConfig = new Tomcat50Configuration(folder);
                } else if (id.indexOf("55") > 0) {
                    tcConfig = new Tomcat55Configuration(folder);
                } else if (id.indexOf("60") > 0) {
                    tcConfig = new Tomcat60Configuration(folder);
                } else if (id.indexOf("70") > 0) {
                    tcConfig = new Tomcat70Configuration(folder);
                } else if (id.indexOf("80") > 0) {
                    tcConfig = new Tomcat80Configuration(folder);
                } else if (id.indexOf("85") > 0) {
                    tcConfig = new Tomcat85Configuration(folder);
                } else if (id.indexOf("90") > 0) {
                    tcConfig = new Tomcat90Configuration(folder);
                } else if (id.indexOf("100") > 0) {
                    tcConfig = new Tomcat100Configuration(folder);
                } else if (id.indexOf("101") > 0) {
                    tcConfig = new Tomcat101Configuration(folder);
                } else if (id.indexOf("110") > 0) {
                    tcConfig = new Tomcat110Configuration(folder);
                } else {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorUnknownVersion, null));
                }
            }
            tcConfig.load(folder, null);
            Object object2 = this.versionLock;
            synchronized (object2) {
                if (this.configuration == null || this.loadedVersion < current) {
                    this.configuration = tcConfig;
                    this.loadedVersion = current;
                }
            }
        }
        return tcConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        TomcatConfiguration tcConfig;
        Object object = this.versionLock;
        synchronized (object) {
            this.configuration = null;
            this.currentVersion = 0;
            this.loadedVersion = 0;
        }
        if (runtime == null) {
            return;
        }
        IPath path = runtime.getLocation().append("conf");
        String id = this.getServer().getServerType().getId();
        IFolder folder = this.getServer().getServerConfiguration();
        if (id.indexOf("32") > 0) {
            tcConfig = new Tomcat32Configuration(folder);
        } else if (id.indexOf("40") > 0) {
            tcConfig = new Tomcat40Configuration(folder);
        } else if (id.indexOf("41") > 0) {
            tcConfig = new Tomcat41Configuration(folder);
        } else if (id.indexOf("50") > 0) {
            tcConfig = new Tomcat50Configuration(folder);
        } else if (id.indexOf("55") > 0) {
            tcConfig = new Tomcat55Configuration(folder);
        } else if (id.indexOf("60") > 0) {
            tcConfig = new Tomcat60Configuration(folder);
        } else if (id.indexOf("70") > 0) {
            tcConfig = new Tomcat70Configuration(folder);
        } else if (id.indexOf("80") > 0) {
            tcConfig = new Tomcat80Configuration(folder);
        } else if (id.indexOf("85") > 0) {
            tcConfig = new Tomcat85Configuration(folder);
        } else if (id.indexOf("90") > 0) {
            tcConfig = new Tomcat90Configuration(folder);
        } else if (id.indexOf("100") > 0) {
            tcConfig = new Tomcat100Configuration(folder);
        } else if (id.indexOf("101") > 0) {
            tcConfig = new Tomcat101Configuration(folder);
        } else if (id.indexOf("110") > 0) {
            tcConfig = new Tomcat110Configuration(folder);
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorUnknownVersion, null));
        }
        ((TomcatConfiguration)tcConfig).importFromPath(path, this.isTestEnvironment(), monitor);
        Object object2 = this.versionLock;
        synchronized (object2) {
            if (this.configuration == null) {
                this.configuration = tcConfig;
            }
        }
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        TomcatConfiguration tcConfig = this.configuration;
        if (tcConfig == null) {
            return;
        }
        tcConfig.save(this.getServer().getServerConfiguration(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged() {
        Object object = this.versionLock;
        synchronized (object) {
            ++this.currentVersion;
        }
    }

    public URL getModuleRootURL(IModule module) {
        TomcatConfiguration config;
        block7: {
            block6: {
                try {
                    if (module != null) break block6;
                    return null;
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Could not get root URL", e);
                    return null;
                }
            }
            config = this.getTomcatConfiguration();
            if (config != null) break block7;
            return null;
        }
        String url = "http://" + this.getServer().getHost();
        int port = config.getMainPort().getPort();
        port = ServerUtil.getMonitoredPort((IServer)this.getServer(), (int)port, (String)"web");
        if (port != 80) {
            url = url + ":" + port;
        }
        if (!(url = url + config.getWebModuleURL(module)).endsWith("/")) {
            url = url + "/";
        }
        return new URL(url);
    }

    public boolean isDebug() {
        return this.getAttribute(PROPERTY_DEBUG, false);
    }

    @Override
    public boolean isTestEnvironment() {
        return this.getAttribute("testEnvironment", false);
    }

    public boolean isSecure() {
        return this.getAttribute(PROPERTY_SECURE, false);
    }

    @Override
    public String getInstanceDirectory() {
        return this.getAttribute("instanceDir", null);
    }

    @Override
    public String getDeployDirectory() {
        return this.getAttribute("deployDir", "webapps");
    }

    @Override
    public boolean isServeModulesWithoutPublish() {
        ITomcatVersionHandler tvh = this.getTomcatVersionHandler();
        if (tvh != null && tvh.supportsServeModulesWithoutPublish()) {
            return this.getAttribute("serveModulesWithoutPublish", false);
        }
        return false;
    }

    @Override
    public boolean isSaveSeparateContextFiles() {
        ITomcatVersionHandler tvh = this.getTomcatVersionHandler();
        if (tvh != null && tvh.supportsSeparateContextFiles()) {
            return this.getAttribute("saveSeparateContextFiles", false);
        }
        return false;
    }

    @Override
    public boolean isSecurityManagerSupported() {
        ITomcatVersionHandler tvh = this.getTomcatVersionHandler();
        if (tvh != null) {
            return tvh.supportsSecurityManager();
        }
        return true;
    }

    public boolean isModulesReloadableByDefault() {
        ITomcatVersionHandler tvh = this.getTomcatVersionHandler();
        if (tvh != null) {
            return this.getAttribute("modulesReloadableByDefault", true);
        }
        return true;
    }

    public IPath getRuntimeBaseDirectory() {
        ITomcatVersionHandler tvh = this.getTomcatVersionHandler();
        if (tvh != null) {
            return tvh.getRuntimeBaseDirectory(this);
        }
        return null;
    }

    public IPath getServerDeployDirectory() {
        String deployDir = this.getDeployDirectory();
        Path deployPath = new Path(deployDir);
        if (!deployPath.isAbsolute()) {
            IPath base = this.getRuntimeBaseDirectory();
            deployPath = base.append((IPath)deployPath);
        }
        return deployPath;
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    public IModule[] getChildModules(IModule[] module) {
        IWebModule webModule;
        if (module == null) {
            return null;
        }
        IModuleType moduleType = module[0].getModuleType();
        if (module.length == 1 && moduleType != null && "jst.web".equals(moduleType.getId()) && (webModule = (IWebModule)module[0].loadAdapter(IWebModule.class, null)) != null) {
            IModule[] modules = webModule.getModules();
            return modules;
        }
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if ("jst.web".equals(module.getModuleType().getId())) {
            IStatus status = this.canModifyModules(new IModule[]{module}, null);
            if (status == null || !status.isOK()) {
                throw new CoreException(status);
            }
            return new IModule[]{module};
        }
        return J2EEUtil.getWebModules((IModule)module, null);
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IModule module = add[i];
                if (!"jst.web".equals(module.getModuleType().getId())) {
                    return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorWebModulesOnly, null);
                }
                if (this.getTomcatVersionHandler() == null) {
                    return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorNoRuntime, null);
                }
                IStatus status = this.getTomcatVersionHandler().canAddModule(module);
                if (status != null && !status.isOK()) {
                    return status;
                }
                if (module.getProject() != null && (status = FacetUtil.verifyFacets((IProject)module.getProject(), (IServer)this.getServer())) != null && !status.isOK()) {
                    return status;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public ServerPort[] getServerPorts() {
        if (this.getServer().getServerConfiguration() == null) {
            return new ServerPort[0];
        }
        try {
            List list = this.getTomcatConfiguration().getServerPorts();
            ServerPort[] sp = new ServerPort[list.size()];
            list.toArray(sp);
            return sp;
        }
        catch (Exception exception) {
            return new ServerPort[0];
        }
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setTestEnvironment(true);
        this.setAttribute("auto-publish-setting", 2);
        this.setAttribute("auto-publish-time", 1);
        this.setDeployDirectory("wtpwebapps");
    }

    public void setDebug(boolean b) {
        this.setAttribute(PROPERTY_DEBUG, b);
    }

    public void setSecure(boolean b) {
        if (this.versionHandler != null && !this.versionHandler.supportsSecurityManager()) {
            this.setAttribute(PROPERTY_SECURE, false);
        } else {
            this.setAttribute(PROPERTY_SECURE, b);
        }
    }

    @Override
    public void setTestEnvironment(boolean b) {
        this.setAttribute("testEnvironment", b);
    }

    @Override
    public void setInstanceDirectory(String instanceDir) {
        this.setAttribute("instanceDir", instanceDir);
    }

    @Override
    public void setDeployDirectory(String deployDir) {
        if ("webapps".equalsIgnoreCase(deployDir)) {
            this.setAttribute("deployDir", null);
        } else {
            this.setAttribute("deployDir", deployDir);
        }
    }

    @Override
    public void setServeModulesWithoutPublish(boolean b) {
        this.setAttribute("serveModulesWithoutPublish", b);
    }

    @Override
    public void setSaveSeparateContextFiles(boolean b) {
        this.setAttribute("saveSeparateContextFiles", b);
    }

    @Override
    public void setModulesReloadableByDefault(boolean b) {
        this.setAttribute("modulesReloadableByDefault", b);
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        IModule module3;
        IStatus status = this.canModifyModules(add, remove);
        if (status == null || !status.isOK()) {
            throw new CoreException(status);
        }
        TomcatConfiguration config = this.getTomcatConfiguration();
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                module3 = add[i];
                IWebModule module = (IWebModule)module3.loadAdapter(IWebModule.class, monitor);
                Object contextRoot = module.getContextRoot();
                if (contextRoot != null && !((String)contextRoot).startsWith("/") && ((String)contextRoot).length() > 0) {
                    contextRoot = "/" + (String)contextRoot;
                }
                String docBase = config.getDocBasePrefix() + module3.getName();
                WebModule module2 = new WebModule((String)contextRoot, docBase, module3.getId(), this.isModulesReloadableByDefault());
                config.addWebModule(-1, module2);
                ++i;
            }
        }
        if (remove != null) {
            int size2 = remove.length;
            int j = 0;
            while (j < size2) {
                module3 = remove[j];
                String memento = module3.getId();
                List modules = this.getTomcatConfiguration().getWebModules();
                int size = modules.size();
                int i = 0;
                while (i < size) {
                    WebModule module = (WebModule)modules.get(i);
                    if (memento.equals(module.getMemento())) {
                        config.removeWebModule(i);
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    public String toString() {
        return "TomcatServer";
    }
}

