/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jsp.jasper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.servlet.JasperInitializer;
import org.eclipse.equinox.internal.jsp.jasper.JspClassLoader;
import org.osgi.annotation.bundle.Referenced;
import org.osgi.framework.Bundle;

@Referenced(value={JspConfigDescriptor.class})
public class JspServlet
extends HttpServlet {
    private static final long serialVersionUID = -4110476909131707652L;
    private final Servlet jspServlet = new org.apache.jasper.servlet.JspServlet();
    Bundle bundle;
    private final URLClassLoader jspLoader;
    String bundleResourcePath;
    String alias;
    static final Map<Method, Method> contextToHandlerMethods = JspServlet.createContextToHandlerMethods();

    public JspServlet(Bundle bundle, String bundleResourcePath, String alias) {
        this.bundle = bundle;
        this.bundleResourcePath = bundleResourcePath == null || bundleResourcePath.equals("/") ? "" : bundleResourcePath;
        this.alias = alias == null || alias.equals("/") ? null : alias;
        this.jspLoader = new JspClassLoader(bundle);
    }

    public JspServlet(Bundle bundle, String bundleResourcePath) {
        this(bundle, bundleResourcePath, null);
    }

    public void init(ServletConfig config) throws ServletException {
        block5: {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.jspLoader);
                this.jspServlet.init((ServletConfig)new ServletConfigAdaptor(config));
                new JasperInitializer().onStartup(Collections.emptySet(), this.getServletContext());
                if (System.getSecurityManager() == null) break block5;
                try {
                    Field jspRuntimeContextField = this.jspServlet.getClass().getDeclaredField("rctxt");
                    jspRuntimeContextField.setAccessible(true);
                    Object jspRuntimeContext = jspRuntimeContextField.get(this.jspServlet);
                    Field permissionCollectionField = jspRuntimeContext.getClass().getDeclaredField("permissionCollection");
                    permissionCollectionField.setAccessible(true);
                    permissionCollectionField.set(jspRuntimeContext, new BundlePermissionCollection(this.bundle));
                }
                catch (Exception e) {
                    throw new ServletException("Cannot initialize JSPServlet. Failed to set JSPRuntimeContext permission collection.");
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.jspLoader);
            this.jspServlet.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/WEB-INF/")) {
            response.sendError(404);
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.jspLoader);
            this.jspServlet.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public ServletConfig getServletConfig() {
        return this.jspServlet.getServletConfig();
    }

    public String getServletInfo() {
        return this.jspServlet.getServletInfo();
    }

    private static Map<Method, Method> createContextToHandlerMethods() {
        Method[] handlerMethods;
        HashMap<Method, Method> methods = new HashMap<Method, Method>();
        Method[] methodArray = handlerMethods = ServletContextAdaptor.class.getDeclaredMethods();
        int n = handlerMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method handlerMethod = methodArray[n2];
            String name = handlerMethod.getName();
            Class<?>[] parameterTypes = handlerMethod.getParameterTypes();
            try {
                Method m = ServletContext.class.getMethod(name, parameterTypes);
                methods.put(m, handlerMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            ++n2;
        }
        return methods;
    }

    private static class BundlePermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = -6365478608043900677L;
        private final Bundle bundle;

        public BundlePermissionCollection(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public void add(Permission permission) {
            throw new SecurityException();
        }

        @Override
        public boolean implies(Permission permission) {
            return this.bundle.hasPermission((Object)permission);
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(Collections.emptyList());
        }
    }

    private class ServletConfigAdaptor
    implements ServletConfig {
        private final ServletConfig config;
        private final ServletContext context;

        public ServletConfigAdaptor(ServletConfig config) {
            this.config = config;
            this.context = this.createServletContext();
        }

        private ServletContext createServletContext() {
            ServletContext configServletContext = this.config.getServletContext();
            ServletContextAdaptor adaptor = new ServletContextAdaptor(configServletContext);
            return adaptor.createServletContext();
        }

        public String getInitParameter(String arg0) {
            return this.config.getInitParameter(arg0);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getServletName() {
            return this.config.getServletName();
        }
    }

    class ServletContextAdaptor {
        private final ServletContext delegate;

        public ServletContextAdaptor(ServletContext delegate) {
            this.delegate = delegate;
        }

        public ServletContext createServletContext() {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Class[] interfaces = new Class[]{ServletContext.class};
            InvocationHandler handler = this.createInvocationHandler();
            return (ServletContext)Proxy.newProxyInstance(classLoader, interfaces, handler);
        }

        private InvocationHandler createInvocationHandler() {
            return (proxy, method, args) -> this.invoke(proxy, method, args);
        }

        Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method m = contextToHandlerMethods.get(method);
            if (m != null) {
                return m.invoke((Object)this, args);
            }
            return method.invoke((Object)this.delegate, args);
        }

        public URL getResource(String name) throws MalformedURLException {
            String file;
            Enumeration entryPaths;
            String resourceName;
            int lastSlash;
            if (JspServlet.this.alias != null && name.startsWith(JspServlet.this.alias)) {
                name = name.substring(JspServlet.this.alias.length());
            }
            if ((lastSlash = (resourceName = JspServlet.this.bundleResourcePath + name).lastIndexOf(47)) == -1) {
                return null;
            }
            String path = resourceName.substring(0, lastSlash);
            if (path.length() == 0) {
                path = "/";
            }
            if ((entryPaths = JspServlet.this.bundle.findEntries(path, file = this.sanitizeEntryName(resourceName.substring(lastSlash + 1)), false)) != null && entryPaths.hasMoreElements()) {
                return (URL)entryPaths.nextElement();
            }
            return this.delegate.getResource(name);
        }

        private String sanitizeEntryName(String name) {
            StringBuffer buffer = null;
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                switch (c) {
                    case '*': 
                    case '\\': {
                        if (buffer == null) {
                            buffer = new StringBuffer(name.length() + 16);
                            buffer.append(name.substring(0, i));
                        }
                        buffer.append('\\').append(c);
                        break;
                    }
                    default: {
                        if (buffer == null) break;
                        buffer.append(c);
                    }
                }
                ++i;
            }
            return buffer == null ? name : buffer.toString();
        }

        public InputStream getResourceAsStream(String name) {
            try {
                URL resourceURL = this.getResource(name);
                if (resourceURL != null) {
                    return resourceURL.openStream();
                }
            }
            catch (IOException e) {
                JspServlet.this.log("Error opening stream for resource '" + name + "'", e);
            }
            return null;
        }

        public Set<String> getResourcePaths(String name) {
            HashSet<String> result = this.delegate.getResourcePaths(name);
            Enumeration e = JspServlet.this.bundle.findEntries(JspServlet.this.bundleResourcePath + name, null, false);
            if (e != null) {
                if (result == null) {
                    result = new HashSet<String>();
                }
                while (e.hasMoreElements()) {
                    URL entryURL = (URL)e.nextElement();
                    result.add(entryURL.getFile().substring(JspServlet.this.bundleResourcePath.length()));
                }
            }
            return result;
        }
    }
}

