/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.wtp.ArtifactHelper;
import org.eclipse.m2e.wtp.MavenSessionHelper;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WTPProjectConfigurator;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.internal.StringUtils;
import org.eclipse.m2e.wtp.overlay.modulecore.IOverlayVirtualComponent;
import org.eclipse.m2e.wtp.overlay.modulecore.OverlayComponentCore;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class OverlayConfigurator
extends WTPProjectConfigurator {
    @Override
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        this.mavenProjectChanged(request.mavenProjectFacade(), monitor);
    }

    @Override
    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        this.mavenProjectChanged(event.getMavenProject(), monitor);
    }

    private void mavenProjectChanged(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        if (facade == null) {
            return;
        }
        IProject project = facade.getProject();
        if (!project.isAccessible() || WTPProjectsUtil.isM2eWtpDisabled(facade, monitor) || project.getResourceAttributes() == null || project.getResourceAttributes().isReadOnly()) {
            return;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        if (!facetedProject.hasProjectFacet(WebFacetUtils.WEB_FACET)) {
            return;
        }
        try {
            this.markerManager.deleteMarkers((IResource)facade.getPom(), "org.eclipse.m2e.core.maven2Problem.wtp.overlayError");
            this.setModuleDependencies(facade, monitor);
        }
        catch (Exception ex) {
            this.markerManager.addErrorMarkers((IResource)facade.getPom(), "org.eclipse.m2e.core.maven2Problem.wtp.overlayError", ex);
        }
    }

    private void setModuleDependencies(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        IProject project = facade.getProject();
        IVirtualComponent warComponent = ComponentCore.createComponent((IProject)project);
        if (warComponent == null) {
            return;
        }
        LinkedHashSet<IVirtualReference> newOverlayRefs = new LinkedHashSet<IVirtualReference>();
        MavenSessionHelper helper = new MavenSessionHelper(facade);
        try {
            IVirtualReference[] updatedOverlayRefs;
            IVirtualReference[] oldOverlayRefs;
            helper.ensureDependenciesAreResolved("maven-war-plugin", "war:war", monitor);
            MavenProject mavenProject = helper.getMavenProject();
            WarPluginConfiguration config = new WarPluginConfiguration(mavenProject, project);
            List<Overlay> overlays = config.getOverlays();
            if (overlays.size() > 1) {
                Collections.reverse(overlays);
                for (Overlay overlay : overlays) {
                    if (overlay.shouldSkip()) continue;
                    Artifact artifact = overlay.getArtifact();
                    IOverlayVirtualComponent overlayComponent = null;
                    IMavenProjectFacade workspaceDependency = this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                    if (workspaceDependency != null) {
                        IProject overlayProject = workspaceDependency.getProject();
                        if (overlayProject.equals((Object)project)) {
                            overlayComponent = OverlayComponentCore.createSelfOverlayComponent((IProject)project);
                        } else if (workspaceDependency.getFullPath(artifact.getFile()) != null) {
                            WTPProjectsUtil.configureWtpUtil(workspaceDependency, monitor);
                            overlayComponent = OverlayComponentCore.createOverlayComponent((IProject)overlayProject);
                        } else {
                            overlayComponent = this.createOverlayArchiveComponent(project, mavenProject, overlay);
                        }
                    } else {
                        overlayComponent = this.createOverlayArchiveComponent(project, mavenProject, overlay);
                    }
                    if (overlayComponent == null) continue;
                    overlayComponent.setInclusions(new LinkedHashSet<String>(Arrays.asList(overlay.getIncludes())));
                    overlayComponent.setExclusions(new LinkedHashSet<String>(Arrays.asList(overlay.getExcludes())));
                    IVirtualReference depRef = ComponentCore.createReference((IVirtualComponent)warComponent, (IVirtualComponent)overlayComponent);
                    String targetPath = StringUtils.nullOrEmpty(overlay.getTargetPath()) ? "/" : overlay.getTargetPath();
                    depRef.setRuntimePath((IPath)new Path(targetPath));
                    newOverlayRefs.add(depRef);
                }
            }
            if (WTPProjectsUtil.hasChanged2(oldOverlayRefs = WTPProjectsUtil.extractHardReferences(warComponent, true), updatedOverlayRefs = newOverlayRefs.toArray(new IVirtualReference[newOverlayRefs.size()]))) {
                IVirtualReference[] nonOverlayRefs = WTPProjectsUtil.extractHardReferences(warComponent, false);
                IVirtualReference[] allRefs = new IVirtualReference[nonOverlayRefs.length + updatedOverlayRefs.length];
                System.arraycopy(nonOverlayRefs, 0, allRefs, 0, nonOverlayRefs.length);
                System.arraycopy(updatedOverlayRefs, 0, allRefs, nonOverlayRefs.length, updatedOverlayRefs.length);
                warComponent.setReferences(allRefs);
            }
        }
        finally {
            helper.dispose();
        }
    }

    private IOverlayVirtualComponent createOverlayArchiveComponent(IProject project, MavenProject mavenProject, Overlay overlay) throws CoreException {
        IPath m2eWtpFolder = ProjectUtils.getM2eclipseWtpFolder(mavenProject, project);
        Path unpackDirPath = new Path(m2eWtpFolder.toOSString() + "/overlays");
        String archiveLocation = ArtifactHelper.getM2REPOVarPath(overlay.getArtifact());
        String targetPath = StringUtils.nullOrEmpty(overlay.getTargetPath()) ? "/" : overlay.getTargetPath();
        IOverlayVirtualComponent component = OverlayComponentCore.createOverlayArchiveComponent((IProject)project, (String)archiveLocation, (IPath)unpackDirPath, (IPath)new Path(targetPath));
        return component;
    }

    @Override
    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        return null;
    }

    @Override
    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        return false;
    }
}

