/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.text;

import java.util.Enumeration;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public class StructuredDocumentWalker {
    IStructuredDocumentRegionList fOldStructuredDocumentRegionList = null;
    IStructuredDocument fStructuredDocument = null;
    String fOriginalChanges = null;
    int fOriginalOffset = 0;
    int fOriginalLengthToReplace = 0;
    int fLengthDifference = 0;

    public StructuredDocumentWalker() {
    }

    public StructuredDocumentWalker(StructuredDocumentEvent event) {
        this.initialize(event);
    }

    public IStructuredDocument getStructuredDocument() {
        return this.fStructuredDocument;
    }

    public IStructuredDocumentRegion getNextNode(IStructuredDocumentRegion node) {
        IStructuredDocumentRegion nextNode = null;
        if (node != null && (nextNode = node.getNext()) == null && this.isOldNode(node)) {
            int newStart = node.getEnd() + this.fLengthDifference;
            nextNode = this.fStructuredDocument.getRegionAtCharacterOffset(newStart);
        }
        return nextNode;
    }

    public IStructuredDocumentRegion getNextNodeInCurrent(IStructuredDocumentRegion node) {
        IStructuredDocumentRegion nextNode = null;
        if (this.isOldNode(node)) {
            IStructuredDocumentRegion oldEndNode = this.fOldStructuredDocumentRegionList.item(this.fOldStructuredDocumentRegionList.getLength() - 1);
            int newStart = oldEndNode.getEnd() + this.fLengthDifference;
            nextNode = this.fStructuredDocument.getRegionAtCharacterOffset(newStart);
        } else if (node != null) {
            nextNode = node.getNext();
        }
        return nextNode;
    }

    public IStructuredDocumentRegion getPrevNode(IStructuredDocumentRegion node) {
        IStructuredDocumentRegion prevNode = null;
        if (node != null && (prevNode = node.getPrevious()) == null && this.isOldNode(node)) {
            int newEnd = node.getStart() - 1;
            prevNode = this.fStructuredDocument.getRegionAtCharacterOffset(newEnd);
        }
        return prevNode;
    }

    public IStructuredDocumentRegion getPrevNodeInCurrent(IStructuredDocumentRegion node) {
        IStructuredDocumentRegion prevNode = null;
        if (this.isOldNode(node)) {
            IStructuredDocumentRegion oldStartNode = this.fOldStructuredDocumentRegionList.item(0);
            int newEnd = oldStartNode.getStart() - 1;
            prevNode = this.fStructuredDocument.getRegionAtCharacterOffset(newEnd);
        } else if (node != null) {
            prevNode = node.getPrevious();
        }
        return prevNode;
    }

    public void initialize(StructuredDocumentEvent event) {
        this.fStructuredDocument = event.getStructuredDocument();
        this.fOriginalChanges = event.getText();
        this.fOriginalOffset = event.getOffset();
        this.fOriginalLengthToReplace = event.getLength();
        this.fLengthDifference = Utilities.calculateLengthDifference((String)this.fOriginalChanges, (int)this.fOriginalLengthToReplace);
        this.fOldStructuredDocumentRegionList = event instanceof StructuredDocumentRegionsReplacedEvent ? ((StructuredDocumentRegionsReplacedEvent)event).getOldStructuredDocumentRegions() : null;
    }

    public boolean isOldNode(IStructuredDocumentRegion node) {
        boolean bOld = false;
        if (this.fOldStructuredDocumentRegionList != null) {
            Enumeration e = this.fOldStructuredDocumentRegionList.elements();
            while (e.hasMoreElements()) {
                if (e.nextElement() != node) continue;
                bOld = true;
                break;
            }
        }
        return bOld;
    }
}

