/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class EvaluateNullableCleanUpCore
extends AbstractMultiFix
implements ICleanUpFix {
    public EvaluateNullableCleanUpCore() {
        this(Collections.emptyMap());
    }

    public EvaluateNullableCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.evaluate_nullable");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.evaluate_nullable")) {
            return new String[]{MultiFixMessages.EvaluateNullableCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.evaluate_nullable")) {
            return "boolean b1 = \"\".equals(s);\nboolean b2 = \"\".equalsIgnoreCase(s);\nboolean b3 = s instanceof String;\n";
        }
        return "boolean b1 = s != null && \"\".equals(s);\nboolean b2 = null != s && \"\".equalsIgnoreCase(s);\nboolean b3 = s != null && s instanceof String;\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.evaluate_nullable")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(InfixExpression visited) {
                if (ASTNodes.hasOperator(visited, InfixExpression.Operator.CONDITIONAL_AND, new InfixExpression.Operator[0])) {
                    List<Expression> operands = ASTNodes.allOperands(visited);
                    int i = 0;
                    while (i < operands.size() - 1) {
                        Expression nullCheckedExpression = ASTNodes.getNullCheckedExpression(operands.get(i));
                        if (nullCheckedExpression != null && this.isNullCheckRedundant(nullCheckedExpression, operands.get(i + 1))) {
                            operands.remove(i);
                            rewriteOperations.add(new EvaluateNullableOperation(visited, operands));
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }

            private boolean isNullCheckRedundant(Expression nullCheckedExpression, Expression nextExpression) {
                if (nullCheckedExpression != null && ASTNodes.isPassive((ASTNode)nullCheckedExpression)) {
                    MethodInvocation methodInvocation;
                    if (nextExpression instanceof InstanceofExpression) {
                        Expression leftOperand = ((InstanceofExpression)nextExpression).getLeftOperand();
                        return ASTNodes.match((ASTNode)leftOperand, (ASTNode)nullCheckedExpression);
                    }
                    if (nextExpression instanceof MethodInvocation && (methodInvocation = (MethodInvocation)nextExpression).getExpression() != null && methodInvocation.getExpression().resolveConstantExpressionValue() != null && methodInvocation.arguments().size() == 1 && ASTNodes.match((ASTNode)((Expression)methodInvocation.arguments().get(0)), (ASTNode)nullCheckedExpression)) {
                        return ASTNodes.usesGivenSignature(methodInvocation, Object.class.getCanonicalName(), "equals", Object.class.getCanonicalName()) || ASTNodes.usesGivenSignature(methodInvocation, String.class.getCanonicalName(), "equalsIgnoreCase", String.class.getCanonicalName());
                    }
                }
                return false;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.EvaluateNullableCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class EvaluateNullableOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final InfixExpression visited;
        private final List<Expression> operands;

        public EvaluateNullableOperation(InfixExpression visited, List<Expression> operands) {
            this.visited = visited;
            this.operands = operands;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.EvaluateNullableCleanUp_description, cuRewrite);
            if (this.operands.size() == 1) {
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)ASTNodes.createMoveTarget(rewrite, this.operands.get(0)), group);
            } else {
                InfixExpression newInfixExpression = ast.newInfixExpression();
                newInfixExpression.setLeftOperand(ASTNodes.createMoveTarget(rewrite, this.operands.remove(0)));
                newInfixExpression.setOperator(this.visited.getOperator());
                newInfixExpression.setRightOperand(ASTNodes.createMoveTarget(rewrite, this.operands.remove(0)));
                newInfixExpression.extendedOperands().addAll(ASTNodes.createMoveTarget(rewrite, this.operands));
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newInfixExpression, group);
            }
        }
    }
}

