/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.osgi.framework.Bundle;

public final class MergeUtils {
    private MergeUtils() {
    }

    private static JMerger getJMerger() {
        FacadeHelper facadeHelper = CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS);
        URL mergeFileURL = FileLocator.find((Bundle)CXFCorePlugin.getDefault().getBundle(), (IPath)new Path("/jmerger/merge.xml"), null);
        JControlModel controlModel = new JControlModel();
        controlModel.initialize(facadeHelper, mergeFileURL.toString());
        JMerger jmerger = new JMerger(controlModel);
        return jmerger;
    }

    public static void merge(File sourceFile, File targetFile) {
        JMerger merger = MergeUtils.getJMerger();
        FileInputStream sourceInputStream = null;
        FileInputStream targetInputStream = null;
        OutputStream targetOutputStream = null;
        try {
            try {
                sourceInputStream = new FileInputStream(sourceFile);
                JCompilationUnit inputCompilationUnit = merger.createCompilationUnitForInputStream((InputStream)sourceInputStream);
                merger.setSourceCompilationUnit(inputCompilationUnit);
                targetInputStream = new FileInputStream(targetFile);
                JCompilationUnit targetCompilationUnit = merger.createCompilationUnitForInputStream((InputStream)targetInputStream);
                merger.setTargetCompilationUnit(targetCompilationUnit);
                merger.merge();
                targetOutputStream = new FileOutputStream(targetFile);
                byte[] bytes = merger.getTargetCompilationUnit().getContents().getBytes();
                targetOutputStream.write(bytes, 0, bytes.length);
            }
            catch (FileNotFoundException fnfe) {
                CXFCorePlugin.log(fnfe);
                try {
                    if (sourceInputStream != null) {
                        sourceInputStream.close();
                    }
                    if (targetInputStream != null) {
                        targetInputStream.close();
                    }
                    if (targetOutputStream != null) {
                        targetOutputStream.close();
                    }
                }
                catch (IOException ioe) {
                    CXFCorePlugin.log(ioe);
                }
            }
            catch (IOException ioe) {
                CXFCorePlugin.log(ioe);
                try {
                    if (sourceInputStream != null) {
                        sourceInputStream.close();
                    }
                    if (targetInputStream != null) {
                        targetInputStream.close();
                    }
                    if (targetOutputStream != null) {
                        targetOutputStream.close();
                    }
                }
                catch (IOException ioe2) {
                    CXFCorePlugin.log(ioe2);
                }
            }
        }
        finally {
            try {
                if (sourceInputStream != null) {
                    sourceInputStream.close();
                }
                if (targetInputStream != null) {
                    targetInputStream.close();
                }
                if (targetOutputStream != null) {
                    targetOutputStream.close();
                }
            }
            catch (IOException ioe) {
                CXFCorePlugin.log(ioe);
            }
        }
    }
}

