/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.LineIndentInfo;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.BaseCodeActionRequest;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolverRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;

public class ResolveCodeActionRequest
extends BaseCodeActionRequest
implements ICodeActionResolverRequest {
    private final CodeAction unresolved;
    private final String participantId;
    private Range range;
    private XMLGenerator generator;
    private LineIndentInfo indentInfo;

    public ResolveCodeActionRequest(CodeAction unresolved, DOMDocument document, IComponentProvider componentProvider, SharedSettings sharedSettings) {
        super(document, componentProvider, sharedSettings);
        this.unresolved = unresolved;
        this.participantId = DataEntryField.getParticipantId(unresolved.getData());
    }

    @Override
    public CodeAction getUnresolved() {
        return this.unresolved;
    }

    @Override
    public String getParticipantId() {
        return this.participantId;
    }

    @Override
    public String getDataProperty(String property) {
        return DataEntryField.getProperty(this.unresolved.getData(), property);
    }

    @Override
    public XMLGenerator getXMLGenerator(Range range) throws BadLocationException {
        if (this.generator == null) {
            this.range = range;
            this.generator = new XMLGenerator(this.getSharedSettings(), this.getSharedSettings().getCompletionSettings().isAutoCloseTags(), this.getLineIndentInfo().getWhitespacesIndent(), this.getLineIndentInfo().getLineDelimiter(), false, Integer.MAX_VALUE, null);
        }
        return this.generator;
    }

    private LineIndentInfo getLineIndentInfo() throws BadLocationException {
        if (this.indentInfo == null) {
            int lineNumber = this.range.getStart().getLine();
            this.indentInfo = this.getDocument().getLineIndentInfo(lineNumber);
        }
        return this.indentInfo;
    }
}

