/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.tips.core.ITipManager;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.core.internal.Messages;

public abstract class TipManager
implements ITipManager {
    private final Map<String, TipProvider> fProviders = new HashMap<String, TipProvider>();
    private final Map<Integer, List<String>> fProviderPrio = new TreeMap<Integer, List<String>>();
    private boolean fOpen;
    private boolean fServeReadTips = false;
    private boolean fIsDiposed;
    private final PropertyChangeSupport fChangeSupport = new PropertyChangeSupport(this);
    public static final int START_DIALOG = 0;
    public static final int START_BACKGROUND = 1;
    public static final int START_DISABLE = 2;

    public TipProvider getProvider(String providerID) {
        this.checkDisposed();
        return this.fProviders.get(providerID);
    }

    @Override
    public ITipManager register(TipProvider provider) {
        this.checkDisposed();
        String message = MessageFormat.format(Messages.TipManager_0, provider.getID(), provider.getDescription());
        this.log(LogUtil.info(message));
        provider.setManager(this);
        this.addToMaps(provider, this.getPriority(provider));
        provider.getChangeSupport().addPropertyChangeListener(event -> {
            if (event.getPropertyName().equals("PR")) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(this, event.getPropertyName(), null, provider);
                newEvent.setPropagationId(event.getPropagationId());
                this.getChangeSupport().firePropertyChange(newEvent);
            }
        });
        return this;
    }

    public PropertyChangeSupport getChangeSupport() {
        return this.fChangeSupport;
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            throw new RuntimeException(Messages.TipManager_2);
        }
    }

    public abstract int getPriority(TipProvider var1);

    private synchronized void addToMaps(TipProvider pProvider, Integer pPriorityHint) {
        this.removeFromMaps(pProvider);
        this.addToProviderMaps(pProvider, pPriorityHint);
        this.addToPriorityMap(pProvider, pPriorityHint);
    }

    private void addToPriorityMap(TipProvider provider, Integer priorityHint) {
        List<String> providers = this.fProviderPrio.get(priorityHint);
        if (!providers.contains(provider.getID())) {
            providers.add(provider.getID());
        }
    }

    private void addToProviderMaps(TipProvider provider, Integer priorityHint) {
        this.fProviders.put(provider.getID(), provider);
        this.fProviderPrio.computeIfAbsent(priorityHint, p -> new ArrayList());
    }

    private void removeFromMaps(TipProvider provider) {
        if (this.fProviders.containsKey(provider.getID())) {
            for (List<String> providers : this.fProviderPrio.values()) {
                providers.remove(provider.getID());
            }
            this.fProviders.remove(provider.getID());
        }
    }

    public List<TipProvider> getProviders() {
        this.checkDisposed();
        if (this.fProviders == null) {
            return Collections.emptyList();
        }
        return this.fProviderPrio.values().stream().flatMap(Collection::stream).map(this.fProviders::get).filter(TipProvider::isReady).toList();
    }

    public int getStartupBehavior() {
        this.checkDisposed();
        return 0;
    }

    public abstract TipManager setStartupBehavior(int var1);

    public void dispose() {
        this.checkDisposed();
        try {
            for (TipProvider provider : this.fProviders.values()) {
                try {
                    provider.dispose();
                }
                catch (Exception e) {
                    this.log(LogUtil.error(e));
                }
            }
        }
        finally {
            this.fProviders.clear();
            this.fProviderPrio.clear();
            this.fIsDiposed = true;
        }
    }

    @Override
    public boolean isOpen() {
        if (this.isDisposed()) {
            return false;
        }
        return this.fOpen;
    }

    protected void setOpen(boolean open) {
        this.fOpen = open;
    }

    public TipManager setServeReadTips(boolean serveRead) {
        this.checkDisposed();
        this.fServeReadTips = serveRead;
        return this;
    }

    @Override
    public boolean mustServeReadTips() {
        this.checkDisposed();
        return this.fServeReadTips;
    }

    public boolean isDisposed() {
        return this.fIsDiposed;
    }

    @Override
    public boolean hasContent() {
        return this.getProviders().stream().anyMatch(p -> p.isReady() && !p.getTips(tip -> !this.isRead((Tip)tip)).isEmpty());
    }
}

