/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ASTIndexerVisitor
extends ASTVisitor {
    private SourceIndexer indexer;
    private Stack<char[]> contextNames;
    private int stackDepth;
    private Set<String> fieldNames;

    public ASTIndexerVisitor(SourceIndexer indexer) {
        super(false);
        this.indexer = indexer;
    }

    @Override
    public boolean visit(JavaScriptUnit node) {
        this.contextNames = new Stack();
        this.stackDepth = 0;
        this.fieldNames = new HashSet<String>();
        return true;
    }

    @Override
    public void endVisit(JavaScriptUnit node) {
        this.contextNames = null;
        this.fieldNames = null;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        char[] fieldSuperName;
        ++this.stackDepth;
        SimpleName name = node.getName();
        if (name == null) {
            return true;
        }
        char[] fieldName = name.getIdentifier().toCharArray();
        char[] cArray = fieldSuperName = this.contextNames.isEmpty() ? null : this.contextNames.peek();
        if (fieldSuperName != null) {
            this.indexer.addFieldDeclaration(null, fieldName, fieldSuperName, 0, false);
        } else {
            this.indexer.addFieldDeclaration(null, fieldName, fieldSuperName, 0, true);
        }
        this.contextNames.push(fieldName);
        if (node.getInitializer() != null) {
            node.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(VariableDeclarationFragment node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(ObjectLiteralField node) {
        char[] fieldName;
        ++this.stackDepth;
        Expression name = node.getFieldName();
        if (name == null) {
            return true;
        }
        switch (name.getNodeType()) {
            case 42: {
                fieldName = ((SimpleName)name).getIdentifier().toCharArray();
                break;
            }
            case 45: {
                fieldName = ((StringLiteral)name).getEscapedValue().toCharArray();
                break;
            }
            default: {
                return true;
            }
        }
        char[] superName = this.contextNames.isEmpty() ? new char[]{} : this.contextNames.peek();
        Expression initializer = node.getInitializer();
        if (initializer.getNodeType() != 84) {
            this.indexer.addFieldDeclaration(null, fieldName, superName, 0, false);
        }
        this.contextNames.push(fieldName);
        return true;
    }

    @Override
    public void endVisit(ObjectLiteralField node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(FunctionDeclaration node) {
        char[] superName;
        char[] methodName;
        ++this.stackDepth;
        Expression name = node.getMethodName();
        boolean isFunction = false;
        if (name != null) {
            methodName = ((SimpleName)name).getIdentifier().toCharArray();
            superName = this.contextNames.isEmpty() ? null : this.contextNames.peek();
        } else {
            if (this.contextNames.isEmpty()) {
                return true;
            }
            methodName = this.contextNames.pop();
            superName = this.contextNames.isEmpty() ? null : this.contextNames.peek();
            this.contextNames.push(methodName);
        }
        List parameters = node.parameters();
        char[][] parameterNames = this.extractParameters(parameters);
        if (node.isConstructor()) {
            this.indexer.addConstructorDeclaration(superName, null, parameterNames, 0);
        } else {
            this.indexer.addMethodDeclaration(methodName, null, parameterNames, null, superName, isFunction, 0);
        }
        this.contextNames.push(methodName);
        if (node.getBody() != null) {
            node.getBody().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(FunctionDeclaration node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        String name;
        if (node.getName() != null) {
            name = node.getName().getIdentifier();
        } else if (node.getExpression() != null && node.getExpression().getNodeType() == 22) {
            name = ((FieldAccess)node.getExpression()).getName().getIdentifier();
        } else {
            return true;
        }
        char[] methodName = name.toCharArray();
        this.indexer.addMethodReference(methodName);
        return true;
    }

    @Override
    public boolean visit(FieldAccess node) {
        char[] fieldName = node.getName().getIdentifier().toCharArray();
        char[] superName = new char[]{};
        Expression expression = node.getExpression();
        switch (expression.getNodeType()) {
            case 52: {
                superName = this.contextNames.isEmpty() ? null : this.contextNames.peek();
                break;
            }
            case 42: {
                superName = ((SimpleName)expression).getIdentifier().toCharArray();
                break;
            }
            case 22: {
                superName = ((FieldAccess)expression).getName().getIdentifier().toCharArray();
            }
        }
        if (node.getParent().getNodeType() != 32) {
            if (node.getParent().getNodeType() == 7 && ((Assignment)node.getParent()).getRightHandSide() == node) {
                this.indexer.addFieldReference(fieldName);
            }
            if (this.isFieldDeclaration(superName, fieldName)) {
                this.indexer.addFieldDeclaration(null, fieldName, superName, 0, false);
            } else {
                this.indexer.addFieldReference(fieldName);
            }
        }
        return true;
    }

    @Override
    public boolean visit(Assignment node) {
        ++this.stackDepth;
        Expression lhs = node.getLeftHandSide();
        char[] elementName = null;
        switch (lhs.getNodeType()) {
            case 42: {
                elementName = ((SimpleName)lhs).getIdentifier().toCharArray();
                break;
            }
            case 22: {
                elementName = ((FieldAccess)lhs).getName().getIdentifier().toCharArray();
            }
        }
        lhs.accept(this);
        if (elementName != null) {
            this.contextNames.push(elementName);
        }
        node.getRightHandSide().accept(this);
        return false;
    }

    @Override
    public void endVisit(Assignment node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(SimpleName node) {
        char[] name = node.getIdentifier().toCharArray();
        this.indexer.addNameReference(name);
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        ++this.stackDepth;
        SimpleName name = node.getName();
        if (name == null) {
            return true;
        }
        char[] simpleTypeName = name.getIdentifier().toCharArray();
        Name superName = null;
        try {
            superName = node.getSuperclass();
        }
        catch (ClassCastException e) {
            Util.verbose("ClassCastException while trying to get superType --- " + e.getMessage() + "\n\t in file : " + this.indexer.document.getPath());
        }
        char[] superTypeName = null;
        if (superName != null) {
            superTypeName = superName.getFullyQualifiedName().toCharArray();
        }
        this.indexer.addTypeDeclaration(0, null, simpleTypeName, superTypeName);
        this.contextNames.push(simpleTypeName);
        return true;
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        Expression name = node.getMember();
        if (name == null || name.getNodeType() != 42) {
            return true;
        }
        char[] className = ((SimpleName)name).getIdentifier().toCharArray();
        this.indexer.addTypeReference(className);
        this.indexer.addConstructorReference(className, 0);
        return true;
    }

    private char[][] extractParameters(List<SingleVariableDeclaration> parameters) {
        char[][] parameterNames = new char[parameters.size()][];
        int i = 0;
        while (i < parameters.size()) {
            SimpleName parameterName = parameters.get(i).getName();
            if (parameterName != null) {
                parameterNames[i] = parameterName.getIdentifier().toCharArray();
            }
            ++i;
        }
        return parameterNames;
    }

    private boolean isFieldDeclaration(char[] superName, char[] fieldName) {
        if (superName == null) {
            superName = new char[]{};
        }
        char[] fullNameArray = new char[fieldName.length + superName.length + 1];
        System.arraycopy(superName, 0, fullNameArray, 0, superName.length);
        fullNameArray[superName.length] = 46;
        System.arraycopy(fieldName, 0, fullNameArray, superName.length + 1, fieldName.length);
        String fullName = new String(fullNameArray);
        if (this.fieldNames.contains(fullName)) {
            return false;
        }
        this.fieldNames.add(fullName);
        return true;
    }
}

