/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.common.command;

import java.util.Collection;
import java.util.Collections;
import org.apache.axis.model.common.CommonPlugin;
import org.apache.axis.model.common.command.AbstractCommand;
import org.apache.axis.model.common.command.Command;
import org.apache.axis.model.common.command.CompoundCommand;

public abstract class AbstractCommand
implements Command {
    protected boolean isPrepared;
    protected boolean isExecutable;
    protected String description;
    protected String label;

    protected AbstractCommand() {
    }

    protected AbstractCommand(String label) {
        this.label = label;
    }

    protected AbstractCommand(String label, String description) {
        this.label = label;
        this.description = description;
    }

    protected boolean prepare() {
        return false;
    }

    public boolean canExecute() {
        if (!this.isPrepared) {
            this.isExecutable = this.prepare();
            this.isPrepared = true;
        }
        return this.isExecutable;
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        throw new UnsupportedOperationException(CommonPlugin.INSTANCE.getString("_EXC_Method_not_implemented", new String[]{String.valueOf(this.getClass().getName()) + ".undo()"}));
    }

    public Collection getResult() {
        return Collections.EMPTY_LIST;
    }

    public Collection getAffectedObjects() {
        return Collections.EMPTY_LIST;
    }

    public String getLabel() {
        return this.label == null ? CommonPlugin.INSTANCE.getString("_UI_AbstractCommand_label") : this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description == null ? CommonPlugin.INSTANCE.getString("_UI_AbstractCommand_description") : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Command chain(Command command) {
        class ChainedCompoundCommand
        extends CompoundCommand {
            final /* synthetic */ AbstractCommand this$0;

            public ChainedCompoundCommand(AbstractCommand abstractCommand) {
                this.this$0 = abstractCommand;
            }

            public Command chain(Command c) {
                this.append(c);
                return this;
            }
        }
        ChainedCompoundCommand result = new ChainedCompoundCommand(this);
        result.append(this);
        result.append(command);
        return result;
    }

    public void dispose() {
    }

    public String toString() {
        String className = this.getClass().getName();
        int lastDotIndex = className.lastIndexOf(46);
        StringBuffer result = new StringBuffer(lastDotIndex == -1 ? className : className.substring(lastDotIndex + 1));
        result.append(" (label: " + this.label + ")");
        result.append(" (description: " + this.description + ")");
        result.append(" (isPrepared: " + this.isPrepared + ")");
        result.append(" (isExecutable: " + this.isExecutable + ")");
        return result.toString();
    }

    public static interface NonDirtying {
    }
}

