/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.TagCreationAttribute;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;
import org.eclipse.jst.pagedesigner.editors.palette.MetadataTagDropSourceData;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolCreationAdapter;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteElementTemplateHelper;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.internal.AbstractCreationCommand;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public class ElementCustomizationCommand
extends AbstractCreationCommand {
    protected final IDOMModel _model;
    protected final Element _element;
    protected final CreationData _creationData;

    public ElementCustomizationCommand(IDOMModel model, Element element, CreationData creationData) {
        this._model = model;
        this._element = element;
        this._creationData = creationData;
    }

    @Override
    public void execute() {
        this.applyChildElementCustomization();
        this.applyAttributeCustomization();
    }

    @Override
    protected boolean prepare() {
        return true;
    }

    protected void applyChildElementCustomization() {
        ITagDropSourceData tagDropSourceData = this._creationData.getTagCreationProvider();
        if (tagDropSourceData != null) {
            MetadataTagDropSourceData provider = TagToolCreationAdapter.createMdTagCreationProvider(tagDropSourceData, this._model);
            PaletteElementTemplateHelper.applyTemplate(this._model, this._element, provider);
        }
    }

    protected final void ensureRequiredAttrs(Element element, CreationData creationData) {
        CMElementDeclaration ed = CMUtil.getTLDElementDeclaration((String)creationData.getUri(), (String)creationData.getTagName(), (IDocument)creationData.getModel().getDocument().getStructuredDocument());
        if (ed != null) {
            for (CMAttributeDeclaration attr : ed.getAttributes()) {
                if (attr.getUsage() != 2 || element.getAttribute(attr.getAttrName()) != null) continue;
                element.setAttribute(attr.getAttrName(), attr.getDefaultValue());
            }
        }
    }

    protected void applyAttributeCustomization() {
        MetadataTagDropSourceData provider;
        List<TagCreationAttribute> list;
        ITagDropSourceData info = this._creationData.getTagCreationProvider();
        if (info != null && (list = (provider = TagToolCreationAdapter.createMdTagCreationProvider(info, this._model)).getAttributes()) != null) {
            for (TagCreationAttribute attr : list) {
                this._element.setAttribute(attr.getId(), attr.getValue() == null ? "" : attr.getValue());
            }
        }
    }

    @Override
    public final Command chain(Command command) {
        return super.chain(command);
    }

    public final Collection<Element> getResult() {
        return Collections.singletonList(this._element);
    }
}

