/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.internal.modulecore.ISingleRootStatus;
import org.eclipse.jst.common.internal.modulecore.SingleRootStatus;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class SingleRootUtil {
    public static final int INCLUDE_FIRST_ERROR = 8;
    public static final int INCLUDE_ALL = 7;
    public static final int INCLUDE_ERRORS_AND_WARNINGS = 6;
    public static final int INCLUDE_ERRORS = 4;
    private static final int WARNINGS = 2;
    private static final int INFO = 1;
    private static final int CANCEL = 0;
    private static final int GET_SINGLE_ROOT_CONTAINER = 9;
    private static String USE_SINGLE_ROOT_PROPERTY = "useSingleRoot";
    private IVirtualComponent aComponent;
    private SingleRootCallback callback;
    private List<IContainer> cachedSourceContainers;
    private IContainer[] cachedOutputContainers;
    private MultiStatus wrapperStatus;
    private int VALIDATE_FLAG;

    public SingleRootUtil(IVirtualComponent component) {
        this(component, null);
    }

    public SingleRootUtil(IVirtualComponent component, SingleRootCallback callback) {
        this.aComponent = component;
        this.callback = callback;
    }

    public boolean isSingleRoot() {
        return this.validateSingleRoot(8).getSeverity() != 4;
    }

    public IContainer getSingleRoot() {
        IStatus status = this.validateSingleRoot(9);
        if (status.getSeverity() == 1) {
            IStatus[] children = ((MultiStatus)status).getChildren();
            ISingleRootStatus rootStatus = (ISingleRootStatus)children[0];
            return rootStatus.getSingleRoot();
        }
        return null;
    }

    public IStatus validateSingleRoot(int flag) {
        this.VALIDATE_FLAG = flag;
        this.wrapperStatus = null;
        StructureEdit edit = null;
        try {
            EList resourceMaps;
            edit = StructureEdit.getStructureEditForRead((IProject)this.getProject());
            if (edit == null || edit.getComponent() == null) {
                this.reportStatus(129);
                IStatus iStatus = this.getStatus();
                return iStatus;
            }
            if (this.aComponent.isBinary()) {
                this.reportStatus(138);
                IStatus iStatus = this.getStatus();
                return iStatus;
            }
            Boolean useSingleRoot = this.getUseSingleRootProperty(edit);
            if (useSingleRoot != null) {
                if (!useSingleRoot.booleanValue()) {
                    this.reportStatus(130);
                } else {
                    this.reportStatus(2, this.aComponent.getRootFolder().getUnderlyingFolder());
                }
                IStatus iStatus = this.getStatus();
                return iStatus;
            }
            if (this.hasConsumableReferences(this.aComponent)) {
                this.reportStatus(131);
                if (this.VALIDATE_FLAG == 0) {
                    IStatus iStatus = this.getStatus();
                    return iStatus;
                }
            }
            if (this.rootFoldersHaveLinkedContent()) {
                this.reportStatus(132);
                if (this.VALIDATE_FLAG == 0) {
                    IStatus iStatus = this.getStatus();
                    return iStatus;
                }
            }
            if ((resourceMaps = edit.getComponent().getResources()).size() < 1) {
                this.reportStatus(133);
                IStatus iStatus = this.getStatus();
                return iStatus;
            }
            if (this.callback != null && this.callback.canValidate(this.aComponent)) {
                this.callback.validate(this, this.aComponent, this.getProject(), (List)resourceMaps);
            }
            if (this.VALIDATE_FLAG != 0) {
                this.validateProject((List)resourceMaps);
            }
            IStatus iStatus = this.getStatus();
            return iStatus;
        }
        finally {
            this.cachedOutputContainers = null;
            this.cachedSourceContainers = null;
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    protected Boolean getUseSingleRootProperty(StructureEdit edit) {
        WorkbenchComponent wbComp = edit.getComponent();
        EList componentProperties = wbComp.getProperties();
        if (componentProperties != null) {
            for (Property wbProperty : componentProperties) {
                if (!USE_SINGLE_ROOT_PROPERTY.equals(wbProperty.getName())) continue;
                return Boolean.valueOf(wbProperty.getValue());
            }
        }
        return null;
    }

    protected boolean hasConsumableReferences(IVirtualComponent vc) {
        IVirtualReference[] refComponents = vc.getReferences();
        int i = 0;
        while (i < refComponents.length) {
            IVirtualReference reference = refComponents[i];
            if (reference != null && reference.getDependencyType() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void validateProject(List resourceMaps) {
        if (this.isRootResourceMapping(resourceMaps)) {
            IContainer[] javaOutputFolders = this.getJavaOutputFolders();
            if (javaOutputFolders.length == 1) {
                if (!this.isSourceContainer(javaOutputFolders[0])) {
                    this.reportStatus(1, javaOutputFolders[0]);
                    return;
                }
                IPath javaOutputPath = this.getJavaOutputFolders()[0].getProjectRelativePath();
                IContainer[] rootFolders = this.aComponent.getRootFolder().getUnderlyingFolders();
                int i = 0;
                while (i < rootFolders.length) {
                    IPath compRootPath = rootFolders[i].getProjectRelativePath();
                    if (javaOutputPath.equals((Object)compRootPath)) {
                        this.reportStatus(1, this.aComponent.getRootFolder().getUnderlyingFolder());
                        return;
                    }
                    ++i;
                }
                this.reportStatus(134);
            } else {
                this.reportStatus(135);
            }
        }
    }

    public IContainer[] getJavaOutputFolders() {
        if (this.cachedOutputContainers == null) {
            this.cachedOutputContainers = SingleRootUtil.getJavaOutputFolders(this.aComponent);
        }
        return this.cachedOutputContainers;
    }

    public static IContainer[] getJavaOutputFolders(IVirtualComponent component) {
        if (component == null) {
            return new IContainer[0];
        }
        List<IContainer> l = JavaLiteUtilities.getJavaOutputContainers(component);
        return l.toArray(new IContainer[l.size()]);
    }

    public boolean isSourceContainer(IContainer sourceContainer) {
        if (this.cachedSourceContainers == null) {
            this.cachedSourceContainers = SingleRootUtil.getSourceContainers(this.aComponent);
        }
        return this.cachedSourceContainers.contains(sourceContainer);
    }

    public static List<IContainer> getSourceContainers(IVirtualComponent component) {
        if (component == null) {
            Collections.emptyList();
        }
        return JavaLiteUtilities.getJavaSourceContainers(component);
    }

    private boolean rootFoldersHaveLinkedContent() {
        if (this.aComponent != null) {
            IContainer[] rootFolders = this.aComponent.getRootFolder().getUnderlyingFolders();
            int i = 0;
            while (i < rootFolders.length) {
                try {
                    boolean hasLinkedContent = this.hasLinkedContent((IResource)rootFolders[i]);
                    if (hasLinkedContent) {
                        return true;
                    }
                }
                catch (CoreException coreEx) {
                    CommonFrameworksPlugin.logError(coreEx);
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasLinkedContent(IResource resourceToCheck) throws CoreException {
        if (resourceToCheck != null && resourceToCheck.isAccessible()) {
            if (resourceToCheck.isLinked()) {
                return true;
            }
            switch (resourceToCheck.getType()) {
                case 2: {
                    IResource[] subDirContents = ((IFolder)resourceToCheck).members();
                    int i = 0;
                    while (i < subDirContents.length) {
                        if (this.hasLinkedContent(subDirContents[i])) {
                            return true;
                        }
                        ++i;
                    }
                    break;
                }
                case 1: {
                    return resourceToCheck.isLinked();
                }
            }
        }
        return false;
    }

    private boolean isRootResourceMapping(List resourceMaps) {
        int i = 0;
        while (i < resourceMaps.size()) {
            ComponentResource resourceMap = (ComponentResource)resourceMaps.get(i);
            if (!this.isRootMapping(resourceMap)) {
                this.reportStatus(136, resourceMap.getRuntimePath());
                if (this.VALIDATE_FLAG == 0) {
                    return false;
                }
            }
            IPath sourcePath = resourceMap.getSourcePath();
            IResource sourceResource = this.getProject().findMember(sourcePath);
            if (sourceResource != null && sourceResource.exists()) {
                if (sourceResource instanceof IContainer && !this.isSourceContainer((IContainer)sourceResource)) {
                    this.reportStatus(137, sourcePath);
                }
            } else {
                this.reportStatus(33, sourcePath);
            }
            if (this.VALIDATE_FLAG == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isRootMapping(ComponentResource map) {
        return map.getRuntimePath().equals((Object)Path.ROOT);
    }

    public IProject getProject() {
        return this.aComponent.getProject();
    }

    public void reportStatus(int code) {
        this.reportStatus(code, null, null);
    }

    public void reportStatus(int code, IContainer container) {
        this.reportStatus(code, null, container);
    }

    public void reportStatus(int code, IPath path) {
        this.reportStatus(code, path, null);
    }

    public void reportStatus(int code, IPath path, IContainer container) {
        SingleRootStatus status = new SingleRootStatus(code, path, container);
        if (status.getSeverity() == 4) {
            if ((this.VALIDATE_FLAG & 8) != 0) {
                this.VALIDATE_FLAG = 0;
                this.addStatus(status);
            } else if ((this.VALIDATE_FLAG & 4) != 0) {
                this.addStatus(status);
            }
        } else if (status.getSeverity() == 2 && (this.VALIDATE_FLAG & 2) != 0) {
            this.addStatus(status);
        } else if (status.getSeverity() == 1 && (this.VALIDATE_FLAG & 1) != 0) {
            this.VALIDATE_FLAG = 0;
            this.addStatus(status);
        }
    }

    public int getValidateFlag() {
        return this.VALIDATE_FLAG;
    }

    public void setValidateFlag(int validateFlag) {
        this.VALIDATE_FLAG = validateFlag;
    }

    public IStatus getStatus() {
        if (this.wrapperStatus != null) {
            return this.wrapperStatus;
        }
        return Status.OK_STATUS;
    }

    private void addStatus(ISingleRootStatus status) {
        if (this.wrapperStatus == null) {
            this.wrapperStatus = new MultiStatus("org.eclipse.jst.common.frameworks", 0, new IStatus[]{status}, null, null);
        } else {
            this.wrapperStatus.add((IStatus)status);
        }
    }

    public static interface SingleRootCallback {
        public boolean canValidate(IVirtualComponent var1);

        public void validate(SingleRootUtil var1, IVirtualComponent var2, IProject var3, List var4);
    }
}

