/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import org.eclipse.e4.tools.emf.editor3x.Messages;
import org.eclipse.e4.tools.emf.editor3x.UndoAction;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.action.Action;

public class RedoAction
extends Action {
    private final IModelResource resource;
    private final IModelResource.ModelListener listener;

    public RedoAction(IModelResource resource) {
        this.resource = resource;
        this.listener = new IModelResource.ModelListener(){

            public void commandStackChanged() {
                RedoAction.this.update();
            }

            public void dirtyChanged() {
            }
        };
        resource.addModelListener(this.listener);
        this.update();
    }

    public void run() {
        if (this.resource.getEditingDomain().getCommandStack().canRedo()) {
            this.resource.getEditingDomain().getCommandStack().redo();
        }
    }

    private void update() {
        if (this.resource.getEditingDomain().getCommandStack().canRedo()) {
            Command redoCommand = this.resource.getEditingDomain().getCommandStack().getRedoCommand();
            String label = UndoAction.getCommandLabel(redoCommand);
            this.setText(Messages.RedoAction_Redo + " " + label);
            this.setEnabled(true);
        } else {
            this.setText(Messages.RedoAction_Redo);
            this.setEnabled(false);
        }
    }

    public void dispose() {
        this.resource.removeModelListener(this.listener);
    }
}

