/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.CachingDistance;
import org.eclipse.emf.compare.match.eobject.EditionDistance;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProvider;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.eobject.WeightProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.match.resource.IResourceMatcher;
import org.eclipse.emf.compare.match.resource.IResourceMatchingStrategy;
import org.eclipse.emf.compare.match.resource.StrategyResourceMatcher;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DefaultMatchEngine
implements IMatchEngine {
    public static final int DEFAULT_EOBJECT_URI_CACHE_MAX_SIZE = 1024;
    private static final String UNKNOWN_ID = "Unknown ID";
    private final IEObjectMatcher eObjectMatcher;
    private final IResourceMatcher resourceMatcher;
    private final IComparisonFactory comparisonFactory;

    public DefaultMatchEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        this(matcher, new StrategyResourceMatcher(), comparisonFactory);
    }

    public DefaultMatchEngine(IEObjectMatcher eObjectMatcher, IResourceMatcher resourceMatcher, IComparisonFactory comparisonFactory) {
        this.eObjectMatcher = (IEObjectMatcher)Preconditions.checkNotNull((Object)eObjectMatcher);
        this.resourceMatcher = (IResourceMatcher)Preconditions.checkNotNull((Object)resourceMatcher);
        this.comparisonFactory = (IComparisonFactory)Preconditions.checkNotNull((Object)comparisonFactory);
    }

    @Override
    public Comparison match(IComparisonScope scope, Monitor monitor) {
        Comparison comparison = this.comparisonFactory.createComparison();
        Notifier left = scope.getLeft();
        Notifier right = scope.getRight();
        Notifier origin = scope.getOrigin();
        comparison.setThreeWay(origin != null);
        this.match(comparison, scope, left, right, origin, monitor);
        this.verifyEClassConsistency(comparison, monitor);
        return comparison;
    }

    private void verifyEClassConsistency(Comparison comparison, Monitor monitor) {
        comparison.getMatches().forEach(match -> this.verifyEClassConsistency((Match)match, monitor));
    }

    private void verifyEClassConsistency(Match match, Monitor monitor) {
        if (monitor.isCanceled()) {
            throw new ComparisonCanceledException();
        }
        this.checkForEClassDifferences(match, monitor);
        match.getSubmatches().forEach(subMatch -> this.verifyEClassConsistency((Match)subMatch, monitor));
    }

    private void checkForEClassDifferences(Match match, Monitor monitor) {
        Diagnostic diagnostic = null;
        if (monitor.isCanceled()) {
            throw new ComparisonCanceledException();
        }
        EObject left = match.getLeft();
        EObject right = match.getRight();
        if (match.getComparison().isThreeWay()) {
            diagnostic = this.checkThreeWayCase(match, left, right);
        } else if (right != null && left != null && !this.isSameEClass(left, right)) {
            String message = this.computeMessage(right, left);
            diagnostic = new BasicDiagnostic(4, "org.eclipse.emf.compare", 0, message, new Object[0]);
        }
        if (diagnostic != null) {
            Comparison comparison = match.getComparison();
            Diagnostic currentDiag = comparison.getDiagnostic();
            if (currentDiag == null) {
                comparison.setDiagnostic(diagnostic);
            }
            ((BasicDiagnostic)comparison.getDiagnostic()).merge(diagnostic);
        }
    }

    private Diagnostic checkThreeWayCase(Match match, EObject left, EObject right) {
        BasicDiagnostic diagnostic = null;
        EObject origin = match.getOrigin();
        if (origin != null) {
            if (left == null && right != null && !this.isSameEClass(right, origin)) {
                String message = this.computeMessage(right, origin);
                diagnostic = new BasicDiagnostic(4, "org.eclipse.emf.compare", 0, message, new Object[0]);
            } else if (right == null && left != null && !this.isSameEClass(left, origin)) {
                String message = this.computeMessage(left, origin);
                diagnostic = new BasicDiagnostic(4, "org.eclipse.emf.compare", 0, message, new Object[0]);
            } else if (!(right == null || left == null || this.isSameEClass(right, origin) && this.isSameEClass(left, origin))) {
                String message = this.computeThreeWayMessage(origin, left, right);
                diagnostic = new BasicDiagnostic(4, "org.eclipse.emf.compare", 0, message, new Object[0]);
            }
        } else if (right != null && left != null && !this.isSameEClass(left, right)) {
            String message = this.computeMessage(right, left);
            diagnostic = new BasicDiagnostic(4, "org.eclipse.emf.compare", 0, message, new Object[0]);
        }
        return diagnostic;
    }

    private boolean isSameEClass(EObject left, EObject right) {
        return right.eClass().isInstance((Object)left) || this.isDynamicEObject(left) && this.isDynamicEObject(right);
    }

    private boolean isDynamicEObject(EObject eObject) {
        return eObject instanceof DynamicEObjectImpl;
    }

    private String computeMessage(EObject first, EObject second) {
        return EMFCompareMessages.getString("DefaultDiffEngine.comparison.eClass", first.eClass().getName(), this.computeElementPath(first), second.eClass().getName(), this.computeElementPath(second));
    }

    private String computeThreeWayMessage(EObject origin, EObject left, EObject right) {
        return EMFCompareMessages.getString("DefaultDiffEngine.comparison.threeway.eClass", origin.eClass().getName(), this.computeElementPath(origin), left.eClass().getName(), right.eClass().getName(), this.computeElementPath(left), this.computeElementPath(right));
    }

    private String computeElementPath(EObject element) {
        return String.valueOf(this.getElementResourcePath(element)) + "#" + this.getElementId(element);
    }

    private String getElementId(EObject element) {
        IdentifierEObjectMatcher.DefaultIDFunction defaultIDFunction = new IdentifierEObjectMatcher.DefaultIDFunction();
        return Optional.of(element).map(defaultIDFunction).orElse(UNKNOWN_ID);
    }

    private String getElementResourcePath(EObject element) {
        return Optional.ofNullable(element).map(EObject::eResource).map(Resource::getURI).map(Object::toString).orElse("");
    }

    protected void match(Comparison comparison, IComparisonScope scope, Notifier left, Notifier right, Notifier origin, Monitor monitor) {
        if (left instanceof ResourceSet || right instanceof ResourceSet) {
            this.match(comparison, scope, (ResourceSet)left, (ResourceSet)right, (ResourceSet)origin, monitor);
        } else if (left instanceof Resource || right instanceof Resource) {
            this.match(comparison, scope, (Resource)left, (Resource)right, (Resource)origin, monitor);
        } else if (left instanceof EObject || right instanceof EObject) {
            this.match(comparison, scope, (EObject)left, (EObject)right, (EObject)origin, monitor);
        }
    }

    protected void match(Comparison comparison, IComparisonScope scope, ResourceSet left, ResourceSet right, ResourceSet origin, Monitor monitor) {
        monitor.subTask(EMFCompareMessages.getString("DefaultMatchEngine.monitor.match.resourceSet"));
        Iterator<? extends Resource> leftChildren = scope.getCoveredResources(left);
        Iterator<? extends Resource> rightChildren = scope.getCoveredResources(right);
        Iterator<Object> originChildren = origin != null ? scope.getCoveredResources(origin) : Collections.emptyIterator();
        Iterable<MatchResource> mappings = this.resourceMatcher.createMappings(leftChildren, rightChildren, originChildren);
        LinkedList leftIterators = Lists.newLinkedList();
        LinkedList rightIterators = Lists.newLinkedList();
        LinkedList originIterators = Lists.newLinkedList();
        for (MatchResource mapping : mappings) {
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
            comparison.getMatchedResources().add((Object)mapping);
            Resource leftRes = mapping.getLeft();
            Resource rightRes = mapping.getRight();
            Resource originRes = mapping.getOrigin();
            if (leftRes != null) {
                leftIterators.add(scope.getCoveredEObjects(leftRes));
            }
            if (rightRes != null) {
                rightIterators.add(scope.getCoveredEObjects(rightRes));
            }
            if (originRes == null) continue;
            originIterators.add(scope.getCoveredEObjects(originRes));
        }
        Iterator leftEObjects = Iterators.concat(leftIterators.iterator());
        Iterator rightEObjects = Iterators.concat(rightIterators.iterator());
        Iterator originEObjects = Iterators.concat(originIterators.iterator());
        this.getEObjectMatcher().createMatches(comparison, leftEObjects, rightEObjects, originEObjects, monitor);
    }

    protected void match(Comparison comparison, IComparisonScope scope, Resource left, Resource right, Resource origin, Monitor monitor) {
        URI uri;
        monitor.subTask(EMFCompareMessages.getString("DefaultMatchEngine.monitor.match.resource"));
        MatchResource match = CompareFactory.eINSTANCE.createMatchResource();
        match.setLeft(left);
        match.setRight(right);
        match.setOrigin(origin);
        if (left != null && (uri = left.getURI()) != null) {
            match.setLeftURI(uri.toString());
        }
        if (right != null && (uri = right.getURI()) != null) {
            match.setRightURI(uri.toString());
        }
        if (origin != null && (uri = origin.getURI()) != null) {
            match.setOriginURI(uri.toString());
        }
        comparison.getMatchedResources().add((Object)match);
        if (DefaultMatchEngine.atLeastTwo(left == null, right == null, origin == null)) {
            return;
        }
        Iterator<Object> leftEObjects = left != null ? scope.getCoveredEObjects(left) : Collections.emptyIterator();
        Iterator<Object> rightEObjects = right != null ? scope.getCoveredEObjects(right) : Collections.emptyIterator();
        Iterator<Object> originEObjects = origin != null ? scope.getCoveredEObjects(origin) : Collections.emptyIterator();
        this.getEObjectMatcher().createMatches(comparison, leftEObjects, rightEObjects, originEObjects, monitor);
    }

    protected void match(Comparison comparison, IComparisonScope scope, EObject left, EObject right, EObject origin, Monitor monitor) {
        monitor.subTask(EMFCompareMessages.getString("DefaultMatchEngine.monitor.match.eobject"));
        if (left == null || right == null) {
            throw new IllegalArgumentException();
        }
        Iterator leftEObjects = Iterators.concat((Iterator)Iterators.singletonIterator((Object)left), scope.getChildren(left));
        Iterator rightEObjects = Iterators.concat((Iterator)Iterators.singletonIterator((Object)right), scope.getChildren(right));
        Iterator originEObjects = origin != null ? Iterators.concat((Iterator)Iterators.singletonIterator((Object)origin), scope.getChildren(origin)) : Collections.emptyIterator();
        this.getEObjectMatcher().createMatches(comparison, leftEObjects, rightEObjects, originEObjects, monitor);
    }

    @Deprecated
    protected IResourceMatcher createResourceMatcher() {
        return new StrategyResourceMatcher();
    }

    protected final IResourceMatcher getResourceMatcher() {
        return this.resourceMatcher;
    }

    protected final IEObjectMatcher getEObjectMatcher() {
        return this.eObjectMatcher;
    }

    private static boolean atLeastTwo(boolean condition1, boolean condition2, boolean condition3) {
        return condition1 && (condition2 || condition3) || condition2 && condition3;
    }

    public static IMatchEngine create(UseIdentifiers useIDs) {
        return DefaultMatchEngine.create(useIDs, WeightProviderDescriptorRegistryImpl.createStandaloneInstance(), EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance(), null);
    }

    public static IMatchEngine create(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry) {
        return DefaultMatchEngine.create(useIDs, weightProviderRegistry, EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance(), null);
    }

    public static IMatchEngine create(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry, Collection<IResourceMatchingStrategy> strategies) {
        return DefaultMatchEngine.create(useIDs, weightProviderRegistry, EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance(), strategies);
    }

    public static IMatchEngine create(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry, EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry, Collection<IResourceMatchingStrategy> strategies) {
        DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory(new DefaultEqualityHelperFactory());
        IEObjectMatcher eObjectMatcher = DefaultMatchEngine.createDefaultEObjectMatcher(useIDs, weightProviderRegistry, equalityHelperExtensionProviderRegistry);
        StrategyResourceMatcher resourceMatcher = strategies == null || strategies.isEmpty() ? new StrategyResourceMatcher() : new StrategyResourceMatcher(strategies);
        DefaultMatchEngine matchEngine = new DefaultMatchEngine(eObjectMatcher, resourceMatcher, comparisonFactory);
        return matchEngine;
    }

    public static IEObjectMatcher createDefaultEObjectMatcher(UseIdentifiers useIDs) {
        return DefaultMatchEngine.createDefaultEObjectMatcher(useIDs, WeightProviderDescriptorRegistryImpl.createStandaloneInstance(), EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public static IEObjectMatcher createDefaultEObjectMatcher(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry) {
        return DefaultMatchEngine.createDefaultEObjectMatcher(useIDs, weightProviderRegistry, EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public static IEObjectMatcher createDefaultEObjectMatcher(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry, EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry) {
        IEObjectMatcher matcher;
        EditionDistance editionDistance = new EditionDistance(weightProviderRegistry, equalityHelperExtensionProviderRegistry);
        CachingDistance cachedDistance = new CachingDistance(editionDistance);
        switch (useIDs) {
            case NEVER: {
                matcher = new ProximityEObjectMatcher(cachedDistance);
                break;
            }
            case ONLY: {
                matcher = new IdentifierEObjectMatcher();
                break;
            }
            default: {
                ProximityEObjectMatcher contentMatcher = new ProximityEObjectMatcher(cachedDistance);
                matcher = new IdentifierEObjectMatcher(contentMatcher);
            }
        }
        return matcher;
    }
}

