/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.action;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.SetCurrentConcernCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.SetDefaultConcernCommand;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;

public class ConcernComboContributionItem
extends ContributionItem {
    public static final String CONCERN_CONTRIBUTION_ID = "ConcernContribution";
    private boolean forceSetText;
    private Combo combo;
    private final String[] initStrings;
    private ToolItem toolitem;
    private DDiagram diagram;
    private final IPartService service;
    private IPartListener partListener;
    private TransactionalEditingDomain domain;
    private ResourceSetListener listener;

    public ConcernComboContributionItem(IPartService partService, String initString) {
        this(partService, new String[]{initString});
    }

    public ConcernComboContributionItem(IPartService partService, String[] initStrings) {
        super(CONCERN_CONTRIBUTION_ID);
        this.initStrings = initStrings;
        this.service = partService;
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof DDiagramEditor) {
                    DDiagramEditor editor = (DDiagramEditor)part;
                    DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
                    ConcernComboContributionItem.this.domain = (TransactionalEditingDomain)editor.getAdapter(EditingDomain.class);
                    ConcernComboContributionItem.this.setDiagram(editorDiagram);
                }
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    public DDiagram getDiagram() {
        return this.diagram;
    }

    private void diagramChanged() {
        if (Display.getCurrent() == null) {
            EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    ConcernComboContributionItem.this.refresh(false);
                }
            });
        } else {
            this.refresh(false);
        }
    }

    private String[] getPickableConcerns() {
        if (this.getDiagram() != null && this.getDiagram().getDescription() != null && this.getDiagram().getDescription().getConcerns() != null) {
            String[] data = new String[this.getDiagram().getDescription().getConcerns().getOwnedConcernDescriptions().size()];
            int i = 0;
            while (i < this.getDiagram().getDescription().getConcerns().getOwnedConcernDescriptions().size()) {
                ConcernDescription desc = (ConcernDescription)this.getDiagram().getDescription().getConcerns().getOwnedConcernDescriptions().get(i);
                data[i] = desc.getName();
                ++i;
            }
            return data;
        }
        return new String[0];
    }

    private void refresh(boolean repopulateCombo) {
        block9: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            try {
                if (this.diagram == null || this.domain == null) {
                    this.combo.setEnabled(false);
                    this.combo.setText("");
                } else {
                    int index;
                    if (repopulateCombo) {
                        this.combo.setItems(this.getPickableConcerns());
                    }
                    String currentConcern = "";
                    if (this.getDiagram().getCurrentConcern() != null) {
                        currentConcern = this.getDiagram().getCurrentConcern().getName();
                    }
                    if ((index = this.combo.indexOf(currentConcern)) == -1 || this.forceSetText) {
                        this.combo.setText(currentConcern);
                    } else {
                        this.combo.select(index);
                    }
                    this.combo.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if ("gtk".equals(SWT.getPlatform())) break block9;
                throw exception;
            }
        }
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)100, (int)20, (boolean)true).x;
    }

    protected Control createControl(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConcernComboContributionItem.this.handleWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ConcernComboContributionItem.this.handleWidgetDefaultSelected(e);
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ConcernComboContributionItem.this.refresh(false);
            }
        });
        this.combo.setItems(this.initStrings);
        this.toolitem.setWidth(this.computeWidth((Control)this.combo));
        this.combo.setToolTipText(Messages.ConcernComboContributionItem_tooltip);
        this.refresh(true);
        return this.combo;
    }

    public void dispose() {
        if (this.partListener == null) {
            return;
        }
        this.service.removePartListener(this.partListener);
        this.removeSemanticListener();
        this.diagram = null;
        this.combo = null;
        this.partListener = null;
        this.domain = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    public void setDiagram(DDiagram dia) {
        if (this.diagram == dia) {
            return;
        }
        if (this.domain == null) {
            this.domain = TransactionUtil.getEditingDomain((EObject)dia);
        }
        this.diagram = dia;
        this.removeSemanticListener();
        this.addSemanticListener();
        this.refresh(true);
    }

    private void addSemanticListener() {
        this.listener = new ResourceSetListenerImpl(){

            public NotificationFilter getFilter() {
                return NotificationFilter.NOT_TOUCH.and(NotificationFilter.createNotifierFilter((Object)ConcernComboContributionItem.this.diagram));
            }

            public boolean isPostcommitOnly() {
                return true;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                ConcernComboContributionItem.this.diagramChanged();
            }
        };
        this.domain.addResourceSetListener(this.listener);
    }

    private void removeSemanticListener() {
        if (this.domain != null) {
            this.domain.removeResourceSetListener(this.listener);
        }
    }

    private void handleWidgetDefaultSelected(SelectionEvent event) {
        if (this.diagram != null) {
            if (this.combo.getSelectionIndex() >= 0) {
                this.setCurrentConcern(this.combo.getItem(this.combo.getSelectionIndex()));
            } else {
                this.setCurrentConcern(this.combo.getText());
            }
        }
        this.refresh(false);
    }

    private void setCurrentConcern(String item) {
        boolean foundConcern = false;
        if (item != null && this.getDiagram() != null && this.getDiagram().getDescription() != null && this.getDiagram().getDescription().getConcerns() != null) {
            for (ConcernDescription desc : this.getDiagram().getDescription().getConcerns().getOwnedConcernDescriptions()) {
                if (!desc.getName().equals(item)) continue;
                foundConcern = true;
                this.domain.getCommandStack().execute((Command)new SetCurrentConcernCommand(this.domain, this.diagram, desc));
            }
        }
        if (!foundConcern) {
            this.domain.getCommandStack().execute((Command)new SetDefaultConcernCommand(this.domain, this.diagram));
        }
    }

    private void handleWidgetSelected(SelectionEvent event) {
        this.forceSetText = true;
        this.handleWidgetDefaultSelected(event);
        this.forceSetText = false;
    }
}

