/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.repair;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.tools.api.migration.DiagramCrossReferencer;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.AbstractDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.Identifier;

public class DEdgeDiagramElementState
extends AbstractDiagramElementState<DEdge> {
    private List<ArrangeConstraint> arrangeConstraints = new ArrayList<ArrangeConstraint>();

    public DEdgeDiagramElementState(Identifier id, DiagramCrossReferencer crossReferencer) {
        super(id, crossReferencer);
    }

    @Override
    public void storeElementState(EObject target, DiagramElementMapping mapping, DEdge element) {
        super.storeElementState(target, mapping, element);
        Iterable existingArrangeConstraints = Iterables.filter((Iterable)element.getArrangeConstraints(), ArrangeConstraint.class);
        if (!Iterables.isEmpty((Iterable)existingArrangeConstraints)) {
            Iterables.addAll(this.arrangeConstraints, (Iterable)existingArrangeConstraints);
        }
    }

    @Override
    public void restoreElementState(DEdge element) {
        super.restoreElementState(element);
        if (!this.arrangeConstraints.isEmpty()) {
            element.getArrangeConstraints().addAll(this.arrangeConstraints);
        }
        for (Edge edge : this.edges) {
            CenterEdgeEndModelChangeOperation operation = new CenterEdgeEndModelChangeOperation(edge, false);
            operation.execute();
        }
    }
}

