/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.view.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.view.factories.DiagramFactory;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.DiagramStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class DiagramViewFactory
implements DiagramFactory {
    private PreferencesHint preferencesHint;

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint thePreferencesHint) {
        this.setPreferencesHint(thePreferencesHint);
        Diagram diagram = this.createDiagramView();
        List styles = this.createStyles((View)diagram);
        if (styles.size() > 0) {
            diagram.getStyles().addAll((Collection)styles);
        }
        if (diagramKind != null) {
            diagram.setType(diagramKind);
        }
        if (semanticAdapter != null) {
            diagram.setElement((EObject)semanticAdapter.getAdapter(EObject.class));
        } else {
            diagram.setElement(null);
        }
        this.initializeMeasurementUnit(diagram);
        this.decorateView((View)diagram, semanticAdapter, diagramKind);
        return diagram;
    }

    protected Diagram createDiagramView() {
        return NotationFactory.eINSTANCE.createDiagram();
    }

    protected MeasurementUnit getMeasurementUnit() {
        return MeasurementUnit.HIMETRIC_LITERAL;
    }

    private void initializeMeasurementUnit(Diagram diagram) {
        if (!diagram.isSetMeasurementUnit()) {
            diagram.setMeasurementUnit(this.getMeasurementUnit());
        }
    }

    protected void decorateView(View view, IAdaptable semanticAdapter, String diagramKind) {
        this.initializeFromPreferences(view);
    }

    protected List createStyles(View view) {
        ArrayList<DiagramStyle> styles = new ArrayList<DiagramStyle>();
        styles.add(NotationFactory.eINSTANCE.createDiagramStyle());
        return styles;
    }

    protected void initializeFromPreferences(View view) {
        FontStyle fontStyle;
        IPreferenceStore store = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
        LineStyle lineStyle = (LineStyle)view.getStyle(NotationPackage.Literals.LINE_STYLE);
        if (lineStyle != null) {
            RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"Appearance.lineColor");
            lineStyle.setLineColor(FigureUtilities.RGBToInteger((RGB)lineRGB).intValue());
        }
        if ((fontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE)) != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)"Appearance.defaultFont");
            fontStyle.setFontName(fontData.getName());
            fontStyle.setFontHeight(fontData.getHeight());
            fontStyle.setBold((fontData.getStyle() & 1) != 0);
            fontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"Appearance.fontColor");
            fontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    protected static ViewService getViewService() {
        return ViewService.getInstance();
    }

    protected PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    protected void setPreferencesHint(PreferencesHint preferencesHint) {
        this.preferencesHint = preferencesHint;
    }
}

