/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore.importer.ui;

import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.base.ModelImporterDetailPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xsd.ecore.importer.XSDImporter;
import org.eclipse.xsd.ecore.importer.XSDImporterPlugin;

public class XSDDetailPage
extends ModelImporterDetailPage {
    protected Button createMapButton;
    protected Button sortAttributesButton;

    public XSDDetailPage(ModelImporter modelImporter, String pageName) {
        super(modelImporter, pageName);
        this.setTitle(XSDImporterPlugin.INSTANCE.getString("_UI_XSDImport_title"));
        this.setDescription(XSDImporterPlugin.INSTANCE.getString(this.showGenModel() ? "_UI_XSDImportNewProject_description" : "_UI_XSDImportFile_description"));
    }

    public void dispose() {
        if (this.createMapButton != null) {
            this.createMapButton.removeListener(13, (Listener)this);
            this.createMapButton = null;
        }
        if (this.sortAttributesButton != null) {
            this.sortAttributesButton.removeListener(13, (Listener)this);
            this.sortAttributesButton = null;
        }
        super.dispose();
    }

    public XSDImporter getXSDImporter() {
        return (XSDImporter)this.getModelImporter();
    }

    protected void addDetailControl(Composite parent) {
        GridData data;
        XSDImporter xsdImporter = this.getXSDImporter();
        if (xsdImporter.canCreateEcoreMap()) {
            this.createMapButton = new Button(parent, 32);
            if (xsdImporter.createEcoreMap()) {
                this.createMapButton.setSelection(true);
            }
            this.createMapButton.setText(XSDImporterPlugin.INSTANCE.getString("_UI_Create_XML_Schema_to_Ecore_Map"));
            data = new GridData();
            data.horizontalSpan = 1;
            this.createMapButton.setLayoutData((Object)data);
            this.createMapButton.addListener(13, (Listener)this);
        }
        this.sortAttributesButton = new Button(parent, 32);
        if (xsdImporter.sortAttributes()) {
            this.sortAttributesButton.setSelection(true);
        }
        this.sortAttributesButton.setText(XSDImporterPlugin.INSTANCE.getString("_UI_Sort_Attributes"));
        data = new GridData();
        data.horizontalSpan = 1;
        this.sortAttributesButton.setLayoutData((Object)data);
        this.sortAttributesButton.addListener(13, (Listener)this);
    }

    protected void doHandleEvent(Event event) {
        if (event.type == 13 && (event.widget == this.createMapButton || event.widget == this.sortAttributesButton)) {
            if (event.widget == this.createMapButton) {
                boolean enabled = this.createMapButton.getSelection();
                if (enabled) {
                    MessageDialog.openWarning((Shell)this.getContainer().getShell(), (String)XSDImporterPlugin.INSTANCE.getString("_UI_Create_XML_Schema_to_Ecore_Map").replace("&", ""), (String)XSDImporterPlugin.INSTANCE.getString("_UI_Create_XML_Schema_to_Ecore_Map_message"));
                }
                this.getXSDImporter().setCreateEcoreMap(this.createMapButton.getSelection());
            } else {
                this.getXSDImporter().setSortAttributes(this.sortAttributesButton.getSelection());
            }
            if (this.uriText.getText().trim().length() > 0) {
                this.refreshModel();
                this.getContainer().updateButtons();
            }
        } else {
            super.doHandleEvent(event);
        }
    }
}

