/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.internal.navigator.resources.actions.WorkingSetRootModeActionGroup;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public class WorkingSetActionProvider
extends CommonActionProvider {
    private static final String TAG_CURRENT_WORKING_SET_NAME = "currentWorkingSetName";
    private static final String WORKING_SET_FILTER_ID = "org.eclipse.ui.navigator.resources.filters.workingSet";
    private boolean contributedToViewMenu = false;
    private CommonViewer viewer;
    private INavigatorContentService contentService;
    private NavigatorFilterService filterService;
    private WorkingSetFilterActionGroup workingSetActionGroup;
    private WorkingSetRootModeActionGroup workingSetRootModeActionGroup;
    private final Object originalViewerInput = ResourcesPlugin.getWorkspace().getRoot();
    private IExtensionStateModel extensionStateModel;
    private boolean emptyWorkingSet;
    private IWorkingSet workingSet;
    private IPropertyChangeListener topLevelModeListener;
    private boolean ignoreFilterChangeEvents;
    private final IPropertyChangeListener filterChangeListener = event -> {
        if (this.ignoreFilterChangeEvents) {
            return;
        }
        IWorkingSet newWorkingSet = (IWorkingSet)event.getNewValue();
        this.setWorkingSet(newWorkingSet);
        if (newWorkingSet != null) {
            if (!this.contentService.isActive("org.eclipse.ui.navigator.resources.workingSets")) {
                this.contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resources.workingSets"}, false);
                this.contentService.getActivationService().persistExtensionActivations();
            }
            if (newWorkingSet.isAggregateWorkingSet()) {
                IAggregateWorkingSet agWs = (IAggregateWorkingSet)newWorkingSet;
                IWorkingSet[] comps = agWs.getComponents();
                if (comps.length > 1) {
                    this.viewer.getCommonNavigator().setWorkingSetLabel(WorkbenchNavigatorMessages.WorkingSetActionProvider_multipleWorkingSets);
                } else if (comps.length > 0) {
                    this.viewer.getCommonNavigator().setWorkingSetLabel(comps[0].getLabel());
                } else {
                    this.viewer.getCommonNavigator().setWorkingSetLabel(null);
                }
            } else {
                this.viewer.getCommonNavigator().setWorkingSetLabel(this.workingSet.getLabel());
            }
        } else {
            this.viewer.getCommonNavigator().setWorkingSetLabel(null);
        }
        this.viewer.getFrameList().reset();
    };
    private final WorkingSetManagerListener managerChangeListener = new WorkingSetManagerListener();
    private final IExtensionActivationListener activationListener = new IExtensionActivationListener(){
        private IWorkingSet savedWorkingSet;

        public void onExtensionActivation(String aViewerId, String[] theNavigatorExtensionIds, boolean isActive) {
            String[] stringArray = theNavigatorExtensionIds;
            int n = theNavigatorExtensionIds.length;
            int n2 = 0;
            while (n2 < n) {
                String theNavigatorExtensionId = stringArray[n2];
                if ("org.eclipse.ui.navigator.resources.workingSets".equals(theNavigatorExtensionId)) {
                    if (isActive) {
                        WorkingSetActionProvider.this.extensionStateModel = WorkingSetActionProvider.this.contentService.findStateModel("org.eclipse.ui.navigator.resources.workingSets");
                        WorkingSetActionProvider.this.workingSetRootModeActionGroup.setStateModel(WorkingSetActionProvider.this.extensionStateModel);
                        WorkingSetActionProvider.this.extensionStateModel.addPropertyChangeListener(WorkingSetActionProvider.this.topLevelModeListener);
                        if (this.savedWorkingSet != null) {
                            WorkingSetActionProvider.this.setWorkingSet(this.savedWorkingSet);
                        }
                        WorkingSetActionProvider.this.managerChangeListener.listen();
                    } else {
                        this.savedWorkingSet = WorkingSetActionProvider.this.workingSet;
                        WorkingSetActionProvider.this.setWorkingSet(null);
                        WorkingSetActionProvider.this.viewer.getCommonNavigator().setWorkingSetLabel(null);
                        WorkingSetActionProvider.this.managerChangeListener.ignore();
                        WorkingSetActionProvider.this.workingSetRootModeActionGroup.setShowTopLevelWorkingSets(false);
                        WorkingSetActionProvider.this.extensionStateModel.removePropertyChangeListener(WorkingSetActionProvider.this.topLevelModeListener);
                    }
                }
                ++n2;
            }
        }
    };
    private static final boolean FIRST_TIME = true;

    public void init(ICommonActionExtensionSite aSite) {
        this.viewer = (CommonViewer)aSite.getStructuredViewer();
        this.contentService = aSite.getContentService();
        this.filterService = (NavigatorFilterService)this.contentService.getFilterService();
        this.extensionStateModel = this.contentService.findStateModel("org.eclipse.ui.navigator.resources.workingSets");
        this.workingSetActionGroup = new WorkingSetFilterActionGroup(aSite.getViewSite().getShell(), this.filterChangeListener);
        this.workingSetRootModeActionGroup = new WorkingSetRootModeActionGroup((StructuredViewer)this.viewer, this.extensionStateModel);
        this.topLevelModeListener = event -> {
            this.setWorkingSet(this.workingSet);
            this.viewer.getFrameList().reset();
        };
        if (this.contentService.isActive("org.eclipse.ui.navigator.resources.workingSets")) {
            this.managerChangeListener.listen();
            this.extensionStateModel.addPropertyChangeListener(this.topLevelModeListener);
        }
        this.contentService.getActivationService().addExtensionActivationListener(this.activationListener);
    }

    protected void initWorkingSetFilter(String workingSetName) {
        IWorkingSet workingSet = null;
        if (workingSetName != null && workingSetName.length() > 0) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            workingSet = workingSetManager.getWorkingSet(workingSetName);
        } else if (PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT")) {
            workingSet = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getAggregateWorkingSet();
        }
        if (workingSet != null) {
            this.setWorkingSet(workingSet);
        }
    }

    private void setWorkingSetFilter(IWorkingSet workingSet) {
        this.setWorkingSetFilter(workingSet, true);
    }

    private void setWorkingSetFilter(IWorkingSet workingSet, boolean firstTime) {
        ViewerFilter[] filters;
        ResourceWorkingSetFilter workingSetFilter = null;
        ViewerFilter[] viewerFilterArray = filters = this.viewer.getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof ResourceWorkingSetFilter) {
                workingSetFilter = (ResourceWorkingSetFilter)filter;
                break;
            }
            ++n2;
        }
        if (workingSetFilter == null) {
            if (firstTime) {
                this.filterService.addActiveFilterIds(new String[]{WORKING_SET_FILTER_ID});
                this.filterService.updateViewer();
                this.setWorkingSetFilter(workingSet, false);
                return;
            }
            WorkbenchNavigatorPlugin.log("Required filter org.eclipse.ui.navigator.resources.filters.workingSet is not present. Working set support will not function correctly.", (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, ""));
            return;
        }
        if (this.extensionStateModel.getBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets")) {
            workingSetFilter.setWorkingSet(null);
        } else {
            workingSetFilter.setWorkingSet(this.emptyWorkingSet ? null : workingSet);
        }
    }

    protected void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        this.emptyWorkingSet = workingSet != null && workingSet.isAggregateWorkingSet() && workingSet.isEmpty();
        this.ignoreFilterChangeEvents = true;
        try {
            this.workingSetActionGroup.setWorkingSet(workingSet);
        }
        finally {
            this.ignoreFilterChangeEvents = false;
        }
        if (this.viewer != null) {
            this.setWorkingSetFilter(workingSet);
            if (workingSet == null || this.emptyWorkingSet || !this.extensionStateModel.getBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets")) {
                if (this.viewer.getInput() != this.originalViewerInput) {
                    this.viewer.setInput(this.originalViewerInput);
                } else {
                    this.viewer.refresh();
                }
            } else if (!workingSet.isAggregateWorkingSet()) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                this.viewer.setInput((Object)workingSetManager.createAggregateWorkingSet("", "", new IWorkingSet[]{workingSet}));
            } else {
                this.viewer.setInput((Object)workingSet);
            }
        }
    }

    public void restoreState(IMemento aMemento) {
        super.restoreState(aMemento);
        this.viewer.getControl().getShell().getDisplay().asyncExec(() -> {
            if (this.viewer.getControl().isDisposed()) {
                return;
            }
            boolean showWorkingSets = true;
            if (aMemento != null) {
                Integer showWorkingSetsInt = aMemento.getInteger("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets");
                showWorkingSets = showWorkingSetsInt == null || showWorkingSetsInt == 1;
                this.extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", showWorkingSets);
                this.workingSetRootModeActionGroup.setShowTopLevelWorkingSets(showWorkingSets);
                String lastWorkingSetName = aMemento.getString(TAG_CURRENT_WORKING_SET_NAME);
                this.initWorkingSetFilter(lastWorkingSetName);
            } else {
                showWorkingSets = false;
                this.extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", showWorkingSets);
                this.workingSetRootModeActionGroup.setShowTopLevelWorkingSets(showWorkingSets);
            }
        });
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        if (aMemento != null) {
            int showWorkingSets = this.extensionStateModel.getBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets") ? 1 : 0;
            aMemento.putInteger("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", showWorkingSets);
            if (this.workingSet != null) {
                aMemento.putString(TAG_CURRENT_WORKING_SET_NAME, this.workingSet.getName());
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.contributedToViewMenu) {
            try {
                super.fillActionBars(actionBars);
                this.workingSetActionGroup.fillActionBars(actionBars);
                if (this.workingSetRootModeActionGroup != null) {
                    this.workingSetRootModeActionGroup.fillActionBars(actionBars);
                }
            }
            finally {
                this.contributedToViewMenu = true;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.workingSetActionGroup.dispose();
        if (this.workingSetRootModeActionGroup != null) {
            this.workingSetRootModeActionGroup.dispose();
        }
        this.managerChangeListener.ignore();
        this.extensionStateModel.removePropertyChangeListener(this.topLevelModeListener);
        this.contentService.getActivationService().removeExtensionActivationListener(this.activationListener);
    }

    public IPropertyChangeListener getFilterChangeListener() {
        return this.filterChangeListener;
    }

    public class WorkingSetManagerListener
    implements IPropertyChangeListener {
        private boolean listening = false;

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            Object newValue = event.getNewValue();
            Object oldValue = event.getOldValue();
            String newLabel = null;
            if ("workingSetRemove".equals(property) && oldValue == WorkingSetActionProvider.this.workingSet) {
                newLabel = "";
                WorkingSetActionProvider.this.setWorkingSet(null);
            } else if ("workingSetNameChange".equals(property) && newValue == WorkingSetActionProvider.this.workingSet) {
                newLabel = WorkingSetActionProvider.this.workingSet.getLabel();
            } else if ("workingSetContentChange".equals(property) && newValue == WorkingSetActionProvider.this.workingSet) {
                if (WorkingSetActionProvider.this.workingSet.isAggregateWorkingSet() && WorkingSetActionProvider.this.workingSet.isEmpty()) {
                    if (!WorkingSetActionProvider.this.emptyWorkingSet) {
                        WorkingSetActionProvider.this.emptyWorkingSet = true;
                        WorkingSetActionProvider.this.setWorkingSetFilter(null);
                        newLabel = null;
                    }
                } else if (WorkingSetActionProvider.this.emptyWorkingSet) {
                    WorkingSetActionProvider.this.emptyWorkingSet = false;
                    WorkingSetActionProvider.this.setWorkingSetFilter(WorkingSetActionProvider.this.workingSet);
                    newLabel = WorkingSetActionProvider.this.workingSet.getLabel();
                }
            }
            if (WorkingSetActionProvider.this.viewer != null) {
                if (newLabel != null) {
                    WorkingSetActionProvider.this.viewer.getCommonNavigator().setWorkingSetLabel(newLabel);
                }
                WorkingSetActionProvider.this.viewer.getFrameList().reset();
                WorkingSetActionProvider.this.viewer.refresh();
            }
        }

        public synchronized void listen() {
            if (!this.listening) {
                PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)WorkingSetActionProvider.this.managerChangeListener);
                this.listening = true;
            }
        }

        public synchronized void ignore() {
            if (this.listening) {
                PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)WorkingSetActionProvider.this.managerChangeListener);
                this.listening = false;
            }
        }
    }
}

