/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.preferences.IFieldValidator;
import org.eclipse.dltk.ui.preferences.Messages;
import org.eclipse.dltk.ui.preferences.ValidatorMessages;
import org.eclipse.dltk.utils.PlatformFileUtils;

public final class FieldValidators {
    public static IFieldValidator POSITIVE_NUMBER_VALIDATOR = new PositiveNumberValidator();
    public static IFieldValidator PORT_VALIDATOR = new PortValidator();

    public static class FilePathValidator
    implements IFieldValidator {
        @Override
        public IStatus validate(String text) {
            return this.validate(text, EnvironmentManager.getLocalEnvironment());
        }

        public IStatus validate(String text, IEnvironment environment) {
            StatusInfo status = new StatusInfo();
            if (environment == null) {
                status.setError(Messages.FieldValidators_0);
                return status;
            }
            if (text.trim().length() != 0) {
                IFileHandle file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)environment, (IPath)Path.fromPortableString((String)text));
                if (!file.exists()) {
                    status.setError(MessageFormat.format(ValidatorMessages.FilePathNotExists, text));
                } else if (file.isDirectory()) {
                    status.setError(MessageFormat.format(ValidatorMessages.FilePathIsInvalid, text));
                }
            }
            return status;
        }

        public IStatus validate(URI location, IEnvironment environment) {
            StatusInfo status = new StatusInfo();
            if (environment == null) {
                status.setError(Messages.FieldValidators_0);
                return status;
            }
            IFileHandle file = environment.getFile(location);
            if (file == null || !file.exists()) {
                status.setError(MessageFormat.format(ValidatorMessages.FilePathNotExists, location));
            } else if (file.isDirectory()) {
                status.setError(MessageFormat.format(ValidatorMessages.FilePathIsInvalid, location));
            }
            return status;
        }
    }

    public static class MinimumNumberValidator
    extends PositiveNumberValidator {
        private int minValue;

        public MinimumNumberValidator(int minValue) {
            this.minValue = minValue;
        }

        @Override
        public IStatus validate(String text) {
            StatusInfo status = (StatusInfo)super.validate(text);
            if (!status.isOK()) {
                return status;
            }
            int value = Integer.parseInt(text);
            if (value < this.minValue) {
                status.setError(MessageFormat.format(ValidatorMessages.MinValueInvalid, String.valueOf(this.minValue)));
            }
            return status;
        }
    }

    public static class PortValidator
    implements IFieldValidator {
        @Override
        public IStatus validate(String text) {
            StatusInfo status = new StatusInfo();
            if (text.trim().length() == 0) {
                status.setError(ValidatorMessages.PortIsEmpty);
            } else {
                try {
                    int value = Integer.parseInt(text);
                    if (value < 1000 || value > 65535) {
                        status.setError(MessageFormat.format(ValidatorMessages.PortShouldBeInRange, text));
                    }
                }
                catch (NumberFormatException e) {
                    status.setError(MessageFormat.format(ValidatorMessages.PortShouldBeInRange, text));
                }
            }
            return status;
        }
    }

    public static class PositiveNumberValidator
    implements IFieldValidator {
        @Override
        public IStatus validate(String text) {
            StatusInfo status = new StatusInfo();
            if (text.trim().length() == 0) {
                status.setError(ValidatorMessages.PositiveNumberIsEmpty);
            } else {
                try {
                    int value = Integer.parseInt(text);
                    if (value < 0) {
                        status.setError(MessageFormat.format(ValidatorMessages.PositiveNumberIsInvalid, text));
                    }
                }
                catch (NumberFormatException e) {
                    status.setError(MessageFormat.format(ValidatorMessages.PositiveNumberIsInvalid, text));
                }
            }
            return status;
        }
    }
}

