/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.preferences.IPHPPreferencePageBlock;

public class PHPPreferencePageBlocksRegistry {
    private static final String EXTENSION_POINT_NAME = "phpPreferencePageBlocks";
    private static final String BLOCK_TAG = "block";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PAGE_ID_ATTRIBUTE = "pageId";
    private static final String PDT_PREFIX = "org.eclipse.php.";
    private Dictionary<String, List<PHPPreferencePageBlocksFactory>> pageBlocks = new Hashtable<String, List<PHPPreferencePageBlocksFactory>>();
    private static PHPPreferencePageBlocksRegistry instance = null;
    private static Comparator<IPHPPreferencePageBlock> pageBlockComparator = new PageBlockComparator();

    private PHPPreferencePageBlocksRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.php.ui", EXTENSION_POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (BLOCK_TAG.equals(element.getName())) {
                String preferencesPageID = element.getAttribute(PAGE_ID_ATTRIBUTE);
                this.addBlock(this.pageBlocks, preferencesPageID, element);
            }
            ++i;
        }
    }

    private void addBlock(Dictionary<String, List<PHPPreferencePageBlocksFactory>> dictionary, String preferencesPageID, IConfigurationElement element) {
        List<PHPPreferencePageBlocksFactory> list = dictionary.get(preferencesPageID);
        if (list == null) {
            list = new ArrayList<PHPPreferencePageBlocksFactory>(5);
        }
        list.add(new PHPPreferencePageBlocksFactory(element));
        dictionary.put(preferencesPageID, list);
    }

    private Dictionary<String, List<PHPPreferencePageBlocksFactory>> getPageBlocks() {
        return this.pageBlocks;
    }

    private static PHPPreferencePageBlocksRegistry getInstance() {
        if (instance == null) {
            instance = new PHPPreferencePageBlocksRegistry();
        }
        return instance;
    }

    public static IPHPPreferencePageBlock[] getPHPPreferencePageBlock(String pageId) throws Exception {
        List<PHPPreferencePageBlocksFactory> addonFactories = PHPPreferencePageBlocksRegistry.getInstance().getPageBlocks().get(pageId);
        IPHPPreferencePageBlock[] addons = PHPPreferencePageBlocksRegistry.getBlocks(addonFactories);
        Arrays.sort(addons, pageBlockComparator);
        return addons;
    }

    private static IPHPPreferencePageBlock[] getBlocks(List<?> addonFactories) {
        if (addonFactories == null) {
            return new IPHPPreferencePageBlock[0];
        }
        LinkedList<IPHPPreferencePageBlock> addons = new LinkedList<IPHPPreferencePageBlock>();
        for (Object addonFactory : addonFactories) {
            IPHPPreferencePageBlock pageBlock = ((PHPPreferencePageBlocksFactory)addonFactory).createPHPPreferencePageBlock();
            if (pageBlock == null) continue;
            addons.add(pageBlock);
        }
        return addons.toArray(new IPHPPreferencePageBlock[addons.size()]);
    }

    class PHPPreferencePageBlocksFactory {
        private IConfigurationElement element;
        private IPHPPreferencePageBlock preferencesPageBlock;

        public PHPPreferencePageBlocksFactory(IConfigurationElement element) {
            this.element = element;
        }

        public IPHPPreferencePageBlock createPHPPreferencePageBlock() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(PHPUIMessages.PHPPreferencePageBlocksRegistry_0 + "org.eclipse.php.ui.phpPreferencePageBlocks"){

                public void run() throws Exception {
                    try {
                        PHPPreferencePageBlocksFactory.this.preferencesPageBlock = (IPHPPreferencePageBlock)PHPPreferencePageBlocksFactory.this.element.createExecutableExtension(PHPPreferencePageBlocksRegistry.CLASS_ATTRIBUTE);
                        PHPPreferencePageBlocksFactory.this.preferencesPageBlock.setComparableName(PHPPreferencePageBlocksFactory.this.element.getAttribute(PHPPreferencePageBlocksRegistry.NAME_ATTRIBUTE));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return this.preferencesPageBlock;
        }
    }

    static class PageBlockComparator
    implements Comparator<IPHPPreferencePageBlock> {
        PageBlockComparator() {
        }

        @Override
        public int compare(IPHPPreferencePageBlock firstBlock, IPHPPreferencePageBlock secondBlock) {
            if (firstBlock != null && secondBlock != null) {
                boolean firstIsPDT = firstBlock.getClass().getName().startsWith(PHPPreferencePageBlocksRegistry.PDT_PREFIX);
                boolean secondIsPDT = secondBlock.getClass().getName().startsWith(PHPPreferencePageBlocksRegistry.PDT_PREFIX);
                if (firstIsPDT) {
                    if (!secondIsPDT) {
                        return -1;
                    }
                } else if (secondIsPDT) {
                    return 1;
                }
                return firstBlock.getComparableName().compareTo(secondBlock.getComparableName());
            }
            if (firstBlock == null) {
                return secondBlock == null ? 0 : -1;
            }
            return 1;
        }
    }
}

