/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.digest.Digest;

public class SignatureBufferedOutputStream
extends OutputStream {
    private MessageDigest digest;
    private BufferedOutputStream innerOutputStream;

    public SignatureBufferedOutputStream(OutputStream out) {
        this.innerOutputStream = new BufferedOutputStream(out);
    }

    public SignatureBufferedOutputStream(OutputStream out, int size) {
        this.innerOutputStream = new BufferedOutputStream(out, size);
    }

    public SignatureBufferedOutputStream(OutputStream out, PharPackage pharData) {
        this(out);
        this.digest = !pharData.isUseSignature() || !Digest.DIGEST_MAP.containsKey(pharData.getSignature()) ? Digest.NULL_DIGEST : Digest.DIGEST_MAP.get(pharData.getSignature()).getDigest();
        this.digest.reset();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.innerOutputStream.write(b, off, len);
        this.digest.update(b, off, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.innerOutputStream.write(b);
        this.digest.update((byte)b);
    }

    @Override
    public void close() throws IOException {
        this.innerOutputStream.close();
    }

    public byte[] getSignature() {
        return this.digest.digest();
    }
}

