/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.dltk.ti.EvaluatorStatistics;
import org.eclipse.dltk.ti.GoalEngine;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.ti.IPruner;
import org.eclipse.dltk.ti.TimelimitPruner;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.FieldReferencesGoal;
import org.eclipse.dltk.ti.goals.FieldReferencesGoalEvaluator;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.MethodCallsGoal;
import org.eclipse.dltk.ti.goals.MethodCallsGoalEvaluator;
import org.eclipse.dltk.ti.goals.NullGoalEvaluator;
import org.eclipse.dltk.ti.statistics.IEvaluationStatisticsRequestor;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.typeinference.IPHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPGoalEvaluatorFactory;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.FactoryMethodMethodReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;

public class PHPCachedTypeInferencer
implements IPHPTypeInferencer {
    private final GoalEngine engine;
    private final Map<IGoal, Result> cache = new ConcurrentHashMap<IGoal, Result>();
    private final IEvaluationStatisticsRequestor stat;

    public PHPCachedTypeInferencer() {
        this.engine = new GoalEngine((IGoalEvaluatorFactory)new CachedEvaluatorFactory());
        this.stat = new StatRequestor();
    }

    @Override
    public IEvaluatedType evaluateTypeFactoryMethod(AbstractTypeGoal goal, int timeout) {
        return this.evaluateType(goal, (IPruner)new FactoryMethodGoalsPruner(timeout));
    }

    @Override
    public IEvaluatedType evaluateTypeFactoryMethod(AbstractTypeGoal goal) {
        return this.evaluateTypeFactoryMethod(goal, 3000);
    }

    @Override
    public IEvaluatedType evaluateTypePHPDoc(AbstractTypeGoal goal, int timeout) {
        return this.evaluateType(goal, (IPruner)new PHPDocGoalsPruner(timeout));
    }

    @Override
    public IEvaluatedType evaluateTypePHPDoc(AbstractTypeGoal goal) {
        return this.evaluateTypePHPDoc(goal, 3000);
    }

    @Override
    public IEvaluatedType evaluateTypeHeavy(AbstractTypeGoal goal, int timeout) {
        return this.evaluateType(goal, (IPruner)new PHPDocGoalsPruner(timeout));
    }

    @Override
    public IEvaluatedType evaluateType(AbstractTypeGoal goal) {
        return this.evaluateType(goal, null);
    }

    @Override
    public IEvaluatedType evaluateType(AbstractTypeGoal goal, int timeLimit) {
        return this.evaluateType(goal, (IPruner)new TimelimitPruner((long)timeLimit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEvaluatedType evaluateType(AbstractTypeGoal goal, IPruner pruner) {
        if (!this.cache.containsKey(goal)) {
            GoalEngine goalEngine = this.engine;
            synchronized (goalEngine) {
                this.cache.put((IGoal)goal, new Result(this.engine.evaluateGoal((IGoal)goal, pruner, this.stat)));
            }
        }
        return (IEvaluatedType)this.cache.get((Object)goal).result;
    }

    private class CachedEvaluatorFactory
    extends PHPGoalEvaluatorFactory {
        private CachedEvaluatorFactory() {
        }

        @Override
        public GoalEvaluator createEvaluator(IGoal goal) {
            if (PHPCachedTypeInferencer.this.cache.containsKey(goal)) {
                return new FakeGoalEvaluator(goal, PHPCachedTypeInferencer.this.cache.get(goal));
            }
            GoalEvaluator eval = super.createEvaluator(goal);
            if (eval == null) {
                if (goal.getClass() == FieldReferencesGoal.class) {
                    return new FieldReferencesGoalEvaluator(goal);
                }
                if (goal.getClass() == MethodCallsGoal.class) {
                    return new MethodCallsGoalEvaluator(goal);
                }
                return new NullGoalEvaluator(goal);
            }
            return eval;
        }
    }

    static class FactoryMethodGoalsPruner
    extends TimelimitPruner {
        public FactoryMethodGoalsPruner(long timeLimit) {
            super(timeLimit);
        }

        public boolean prune(IGoal goal, EvaluatorStatistics stat) {
            if (goal instanceof FactoryMethodMethodReturnTypeGoal) {
                return true;
            }
            return super.prune(goal, stat);
        }
    }

    private class FakeGoalEvaluator
    extends GoalEvaluator {
        final Result result;

        public FakeGoalEvaluator(IGoal goal, Result result) {
            super(goal);
            this.result = result;
        }

        public IGoal[] init() {
            return IGoal.NO_GOALS;
        }

        public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
            return IGoal.NO_GOALS;
        }

        public Object produceResult() {
            return this.result.result;
        }
    }

    static class HeavyGoalsPruner
    extends TimelimitPruner {
        public HeavyGoalsPruner(long timeLimit) {
            super(timeLimit);
        }

        public boolean prune(IGoal goal, EvaluatorStatistics stat) {
            if (goal instanceof MethodElementReturnTypeGoal || goal instanceof ClassVariableDeclarationGoal) {
                return true;
            }
            return super.prune(goal, stat);
        }
    }

    static class PHPDocGoalsPruner
    extends TimelimitPruner {
        public PHPDocGoalsPruner(long timeLimit) {
            super(timeLimit);
        }

        public boolean prune(IGoal goal, EvaluatorStatistics stat) {
            if (goal instanceof PHPDocMethodReturnTypeGoal || goal instanceof PHPDocClassVariableGoal) {
                return true;
            }
            return super.prune(goal, stat);
        }
    }

    private class Result {
        final Object result;

        public Result(Object result) {
            this.result = result;
        }
    }

    private class StatRequestor
    implements IEvaluationStatisticsRequestor {
        private StatRequestor() {
        }

        public void evaluationStarted(IGoal rootGoal) {
        }

        public void goalStateChanged(IGoal goal, GoalState state, GoalState oldState) {
        }

        public void goalEvaluatorAssigned(IGoal goal, GoalEvaluator evaluator) {
        }

        public void evaluatorInitialized(GoalEvaluator evaluator, IGoal[] subgoals, long time) {
        }

        public void evaluatorReceivedResult(GoalEvaluator evaluator, IGoal finishedGoal, IGoal[] newSubgoals, long time) {
        }

        public void evaluatorProducedResult(GoalEvaluator evaluator, Object result, long time) {
            if (!(evaluator instanceof FakeGoalEvaluator)) {
                PHPCachedTypeInferencer.this.cache.put(evaluator.getGoal(), new Result(result));
            }
        }
    }
}

