/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;

public final class Utils {
    private static final int SHORT_OBJECT_ID_LENGTH = 7;
    private static final String EMPTY_STRING = "";
    private static final char CR_CHAR = '\r';
    private static final char LF_CHAR = '\n';
    private static final Pattern VERTICAL_SPACES = Pattern.compile("\\v+");

    private Utils() {
    }

    public static String firstLine(String text) {
        Matcher m = VERTICAL_SPACES.matcher(text);
        if (m.find()) {
            return text.substring(0, m.start());
        }
        return text;
    }

    public static boolean isMultiLine(String text) {
        return VERTICAL_SPACES.matcher(text).find();
    }

    public static String toSingleLine(String text) {
        return VERTICAL_SPACES.matcher(text).replaceAll(" ");
    }

    public static String getShortObjectId(ObjectId id) {
        return id.abbreviate(7).name();
    }

    public static String normalizeLineEndings(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return EMPTY_STRING;
        }
        StringBuilder result = new StringBuilder();
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) == '\r') {
                if (i + 1 < length) {
                    if (s.charAt(i + 1) == '\n') {
                        result.append('\n');
                        ++i;
                    } else {
                        result.append('\n');
                    }
                } else {
                    result.append('\n');
                }
            } else {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public static String shortenText(String text, int maxLength) {
        if (text.length() > maxLength) {
            return text.substring(0, maxLength - 1) + "\u2026";
        }
        return text;
    }

    @NonNull
    public static IStatus validateNewRefName(String refNameInput, @NonNull Repository repo, @NonNull String refPrefix, boolean errorOnEmptyName) {
        if (refNameInput == null || refNameInput.isEmpty()) {
            if (errorOnEmptyName) {
                return Activator.error(CoreText.ValidationUtils_PleaseEnterNameMessage, null);
            }
            return Status.OK_STATUS;
        }
        String testFor = refPrefix + refNameInput;
        if (!Repository.isValidRefName((String)testFor)) {
            return Activator.error(MessageFormat.format(CoreText.ValidationUtils_InvalidRefNameMessage, testFor), null);
        }
        try {
            if (repo.exactRef(testFor) != null) {
                return Activator.error(MessageFormat.format(CoreText.ValidationUtils_RefAlreadyExistsMessage, testFor), null);
            }
            RefDatabase refDatabase = repo.getRefDatabase();
            Collection conflictingNames = refDatabase.getConflictingNames(testFor);
            if (!conflictingNames.isEmpty()) {
                String joined = conflictingNames.stream().sorted().collect(Collectors.joining(", "));
                return Activator.error(MessageFormat.format(CoreText.ValidationUtils_RefNameConflictsWithExistingMessage, joined), null);
            }
        }
        catch (IOException e) {
            return Activator.error(e.getMessage(), e);
        }
        catch (RevisionSyntaxException e) {
            String m = MessageFormat.format(CoreText.ValidationUtils_InvalidRevision, testFor);
            return Activator.error(m, e);
        }
        return Status.OK_STATUS;
    }

    public static char commentCharFromMergeMessage(String message) {
        Pattern CONFLICT_LINE = Pattern.compile("(?:^|\\R)(.) Conflicts:\\R");
        Matcher m = CONFLICT_LINE.matcher(message);
        if (m.find()) {
            return m.group(1).charAt(0);
        }
        return '\u0000';
    }
}

