/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.objects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.php.composer.api.collection.UniqueJsonArray;
import org.eclipse.php.composer.api.entities.JsonEntity;
import org.eclipse.php.composer.api.objects.JsonObject;

public class Namespace
extends JsonObject {
    private transient UniqueJsonArray paths = new UniqueJsonArray();

    public Namespace() {
        this.listen();
        this.paths.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Namespace.this.firePropertyChange(Namespace.this.getNamespace() + "." + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public Namespace(String namespacename, String path) {
        this();
        this.setNamespace(namespacename);
        this.add(path);
    }

    @Override
    protected Object buildJson() {
        try {
            Method mtd = JsonEntity.class.getDeclaredMethod("buildJson", new Class[0]);
            return mtd.invoke((Object)this.paths, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected List<String> getOwnProperties() {
        String[] props = new String[]{"paths"};
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(props));
        list.addAll(super.getOwnProperties());
        return list;
    }

    public String getNamespace() {
        return this.getAsString("namespace");
    }

    public void setNamespace(String namespace) {
        this.set("namespace", namespace);
    }

    public void add(String path) {
        this.paths.add(path);
    }

    @Override
    public boolean has(String path) {
        return this.paths.has(path);
    }

    @Override
    public void clear() {
        this.paths.clear();
    }

    public void addPaths(UniqueJsonArray paths) {
        for (Object path : paths) {
            if (this.has((String)path)) continue;
            this.add((String)path);
        }
    }

    public String getFirst() {
        return (String)this.paths.get(0);
    }

    public UniqueJsonArray getPaths() {
        return this.paths;
    }

    @Override
    public void remove(String path) {
        this.paths.remove(path);
    }

    public void removeAll() {
        this.paths.clear();
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    public Namespace clone() {
        Namespace clone = new Namespace();
        this.cloneProperties(clone);
        clone.addPaths(this.paths);
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Namespace) {
            Namespace namespace = (Namespace)obj;
            return namespace == this || (this.getNamespace() == null ? namespace.getNamespace() == null : this.getNamespace().equals(namespace.getNamespace())) && this.getPaths().equals(namespace.getPaths());
        }
        return false;
    }
}

