/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.search;

import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.scout.sdk.core.s.util.search.FileRange;
import org.eclipse.scout.sdk.core.util.Ensure;

public class FileQueryMatch
extends FileRange {
    private final int m_severity;

    public FileQueryMatch(Path file, Path module, CharSequence textOfRange, int start, int end) {
        this(file, module, textOfRange, start, end, Level.OFF.intValue());
    }

    public FileQueryMatch(Path file, Path module, CharSequence textOfRange, int start, int end, int severity) {
        super(file, module, textOfRange, start, end);
        this.m_severity = severity;
    }

    public static FileQueryMatch fromFileRange(FileRange range) {
        return FileQueryMatch.fromFileRange(range, Level.OFF.intValue());
    }

    public static FileQueryMatch fromFileRange(FileRange range, int severity) {
        Ensure.notNull((Object)range);
        return new FileQueryMatch(range.file(), range.module(), range.text(), range.start(), range.end(), severity);
    }

    public int severity() {
        return this.m_severity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileQueryMatch that = (FileQueryMatch)o;
        return this.m_severity == that.m_severity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.m_severity);
    }
}

