/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.query;

import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeElementSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class NodeElementQuery
extends AbstractQuery<INodeElement> {
    private final NodeModuleSpi m_moduleSpi;
    private String m_exportName;
    private boolean m_recursive;

    public NodeElementQuery(NodeModuleSpi module) {
        this.m_moduleSpi = (NodeModuleSpi)Ensure.notNull((Object)module);
    }

    public NodeElementQuery withExportName(String exportName) {
        this.m_exportName = exportName;
        return this;
    }

    protected String exportName() {
        return this.m_exportName;
    }

    public NodeElementQuery withRecursive(boolean recursive) {
        this.m_recursive = recursive;
        return this;
    }

    protected boolean isRecursive() {
        return this.m_recursive;
    }

    protected NodeModuleSpi module() {
        return this.m_moduleSpi;
    }

    protected Stream<INodeElement> createStream() {
        String exportName = this.exportName();
        Stream<NodeElementSpi> result = this.isRecursive() ? this.module().api().packageJson().dependencies().withSelf(true).withRecursive(true).stream().flatMap(module -> NodeElementQuery.createStreamForExportName(module.spi(), exportName)) : NodeElementQuery.createStreamForExportName(this.module(), exportName);
        return result.map(NodeElementSpi::api);
    }

    protected static Stream<NodeElementSpi> createStreamForExportName(NodeModuleSpi module, String exportName) {
        if (exportName == null) {
            return module.elements().keySet().stream();
        }
        return Stream.ofNullable(module.exports().get(exportName));
    }
}

