/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public final class ResourceUtils {
    public static Capability getIdentityCapability(Resource resource) throws IllegalArgumentException {
        ArrayList<Capability> caps = resource.getCapabilities("osgi.identity");
        if (caps.isEmpty()) {
            throw new IllegalArgumentException("Resource has no identity");
        }
        if (caps.size() > 1) {
            ArrayList<Capability> filtered = new ArrayList<Capability>(caps.size());
            ArrayList<String> ids = new ArrayList<String>(caps.size());
            for (Capability cap : caps) {
                String id = ResourceUtils.getIdentity(cap);
                if ("system.bundle".equals(id)) continue;
                filtered.add(cap);
                ids.add(id);
            }
            caps = filtered;
            if (caps.size() > 1) {
                throw new IllegalArgumentException("Resource has multiple identity capabilities: " + String.valueOf(ids));
            }
        }
        return (Capability)caps.get(0);
    }

    public static String getIdentity(Capability identityCapability) throws IllegalArgumentException {
        String id = (String)identityCapability.getAttributes().get("osgi.identity");
        if (id == null) {
            throw new IllegalArgumentException("Resource identity capability has missing identity attribute");
        }
        return id;
    }

    public static Version getVersion(Capability identityCapability) throws IllegalArgumentException {
        Object versionObj = identityCapability.getAttributes().get("version");
        if (versionObj instanceof Version) {
            return (Version)versionObj;
        }
        if (versionObj == null || versionObj instanceof String) {
            return Version.parseVersion((String)((String)versionObj));
        }
        throw new IllegalArgumentException("Resource identity capability has version attribute with incorrect type: " + String.valueOf(versionObj.getClass()));
    }

    public static String getIdentity(Resource resource) throws IllegalArgumentException {
        return ResourceUtils.getIdentity(ResourceUtils.getIdentityCapability(resource));
    }

    public static Version getVersion(Resource resource) throws IllegalArgumentException {
        return ResourceUtils.getVersion(ResourceUtils.getIdentityCapability(resource));
    }

    public static Capability getContentCapability(Resource resource) throws IllegalArgumentException {
        List caps = resource.getCapabilities("osgi.content");
        if (caps.isEmpty()) {
            throw new IllegalArgumentException("Resource has no content");
        }
        Capability firstCap = null;
        for (Capability c : caps) {
            Object url;
            if (firstCap == null) {
                firstCap = c;
            }
            if ((url = c.getAttributes().get("url")) == null) continue;
            String urlString = String.valueOf(url);
            try {
                new URI(urlString).toURL();
                return c;
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return firstCap;
    }

    public static URI getURI(Capability contentCapability) {
        Object uriObj = contentCapability.getAttributes().get("url");
        if (uriObj == null) {
            throw new IllegalArgumentException("Resource content capability has missing URL attribute");
        }
        if (uriObj instanceof URI) {
            return (URI)uriObj;
        }
        try {
            if (uriObj instanceof URL) {
                return ((URL)uriObj).toURI();
            }
            if (uriObj instanceof String) {
                String uriStr = (String)uriObj;
                try {
                    URL url = new URI(uriStr).toURL();
                    return url.toURI();
                }
                catch (MalformedURLException url) {
                    File f = new File((String)uriObj);
                    if (f.isFile()) {
                        return f.toURI();
                    }
                    return new URI((String)uriObj);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Resource content capability has illegal URL attribute", e);
        }
        throw new IllegalArgumentException("Resource content capability has URL attribute with incorrect type: " + String.valueOf(uriObj.getClass()));
    }

    public static String getVersionAttributeForNamespace(String ns) {
        Object name = "osgi.identity".equals(ns) ? "version" : ("osgi.wiring.bundle".equals(ns) ? "bundle-version" : ("osgi.wiring.host".equals(ns) ? "bundle-version" : ("osgi.wiring.package".equals(ns) ? "version" : ("osgi.service".equals(ns) ? null : ("osgi.ee".equals(ns) ? "version" : ("osgi.extender".equals(ns) ? "version" : ("osgi.contract".equals(ns) ? "version" : null)))))));
        return name;
    }
}

